

/*tabela sterujca*/
CREATE TABLE DSET_PARAM
(
	NAZWA nvarchar(255) NOT NULL,
	WARTOSC nvarchar(255)
);

/* nagwek KEDU i DATASET*/
CREATE TABLE KEDU(
	GUIDKEDU uniqueidentifier NOT NULL,
	DATA_ZAPISU datetime DEFAULT (datetime())NOT NULL,
	WERSJA_KEDU nchar(5) NOT NULL,
	WERSJA_SCHEMATU nchar(5) NOT NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PRODUCENT nvarchar(50) NOT NULL,
	SYMBOL nvarchar(50) NOT NULL,
	WERSJA nvarchar(50) NOT NULL,
	DATA_UTWORZENIA_KEDU date NULL,
	SKROT bigint NULL,
 CONSTRAINT PK_KEDU PRIMARY KEY  
(
	GUIDKEDU ASC
)
)
;


/*wszystkie nowe parametry powinny by dopisywane do tabeli DSET_PARAM*/
CREATE TABLE PARAM_WRF
(
	GUIDKEDU uniqueidentifier NOT NULL,
	WER_KONTEKSTOWA char(1), /*wywoa weryfikacj kontekstow*/
	IDENTYFIKACJA char(1), /*czy wykona identyfikacj patnika/ubezpieczonego*/
	WER_DOKUMENTU char(1), /*weryfikacja tylko dokumentu*/
	WER_BLOKU char(1), /*weryfikacja tylko bloku powtarzalnego*/
	CONNECTIONSTRING TEXT,
	ID_PLATNIK int,
	POTWIERDZPESEL char(1),/*czy wykonywa potwierdzanie danych identyfikacyjnych w RU_PESEL*/
	PUBDB_DAJDANEZKONT int,/*kod zwrotny usugi PUBDB.DajDaneZKont*/
	WeryfikujWszystko char(1),/*czy po wyliczeniu kompletu, naley wywoa pen weryfikacj*/	
	/*parametry dla wywoania usugi RUPESEL w kontekscie A1*/
	AdresUslugi TEXT,
	Timeout int,
	UseProxy BOOL, 
	SerwerProxyHttp TEXT, 
	sHttpProxyPort int, 
	SerwerProxyHttpUzytkownik TEXT, 
	SerwerProxyHttpHaslo TEXT, 
	LokalizacjaKonfiguracjaXML TEXT,
	NazwaProducenta TEXT,
	NazwaProduktu TEXT,
	WersjaProduktu TEXT,
	IdProgram int,
CONSTRAINT PK_PARAM_WRF PRIMARY KEY  
(
	GUIDKEDU ASC
)
)
;

/*Tabele dokumentw*/

CREATE TABLE ZUSZZA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 smallint NULL /*Zgoszenie do ubezpieczenia zdrowotnego*/,
	I_2 nvarchar(1) NULL /*Zgoszenie zmiany / korekty danych osoby ubezpiecz*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(11) NULL /*PESEL*/,
	III_2 nvarchar(10) NULL /*NIP*/,
	III_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_5 nvarchar(31) NULL /*Nazwisko*/,
	III_6 nvarchar(22) NULL /*Imi pierwsze*/,
	III_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_1 nvarchar(22) NULL /*Imi drugie*/,
	IV_2 nvarchar(31) NULL /*Nazwisko rodowe*/,
	IV_3 nvarchar(22) NULL /*Obywatelstwo*/,
	IV_4 nvarchar(1) NULL /*Pe*/,
	V_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	V_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	V_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	VI_1 datetime NULL /*Data powstania obowizku ubezpieczenia (dd-mm-rrrr*/,
	VI_2 nvarchar(3) NULL /*Kod oddziau NFZ*/,
	VII_1 datetime NULL /*Data powstania obowizku ubezpieczenia (dd-mm-rrrr*/,
	VII_2 nvarchar(3) NULL /*Kod oddziau NFZ*/,
	VIII_1 nvarchar(5) NULL /*Kod pocztowy*/,
	VIII_2 nvarchar(26) NULL /*Miejscowo*/,
	VIII_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	VIII_4 nvarchar(30) NULL /*Ulica*/,
	VIII_5 nvarchar(7) NULL /*Numer domu*/,
	VIII_6 nvarchar(7) NULL /*Numer lokalu*/,
	VIII_7 nvarchar(12) NULL /*Numer telefonu*/,
	VIII_8 nvarchar(12) NULL /*Symbol pastwa*/,
	IX_1 nvarchar(5) NULL /*Kod pocztowy*/,
	IX_2 nvarchar(26) NULL /*Miejscowo*/,
	IX_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	IX_4 nvarchar(30) NULL /*Ulica*/,
	IX_5 nvarchar(7) NULL /*Numer domu*/,
	IX_6 nvarchar(7) NULL /*Numer lokalu*/,
	IX_7 nvarchar(12) NULL /*Numer telefonu*/,
	IX_8 nvarchar(12) NULL /*Symbol pastwa*/,
	X_1 nvarchar(5) NULL /*Kod pocztowy*/,
	X_2 nvarchar(26) NULL /*Miejscowo*/,
	X_3 nvarchar(30) NULL /*Ulica*/,
	X_4 nvarchar(7) NULL /*Numer domu*/,
	X_5 nvarchar(7) NULL /*Numer lokalu*/,
	X_6 nvarchar(5) NULL /*Skrytka pocztowa*/,
	X_7 nvarchar(12) NULL /*Numer telefonu*/,
	X_8 nvarchar(12) NULL /*Symbol pastwa*/,
	X_9 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	XI_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSZZA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZWUA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 smallint NULL /*Wyrejestrowanie z ubezpiecze spoecznych i ubezpi*/,
	I_2 smallint NULL /*Zgoszenie korekty danych o wyrejestrowaniu z ubez*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(11) NULL /*PESEL*/,
	III_2 nvarchar(10) NULL /*NIP*/,
	III_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_5 nvarchar(31) NULL /*Nazwisko*/,
	III_6 nvarchar(22) NULL /*Imi pierwsze*/,
	III_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	IV_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	IV_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	IV_2 datetime NULL /*Od dnia (dd-mm-rrrr)*/,
	IV_3 NVARCHAR(3) NULL /*Kod przyczyny wyrejestrowania*/,
	V_1 DATETIME, /*Data od*/
	V_2 NVARCHAR(3), /*Kod wyganicia stosunku subowego*/
	V_3 NVARCHAR(3), /*Kod podstawy prawnej rozwizania stosunku subowego*/
	V_4 NVARCHAR(255), /*Podstawa prawna rozwizania stosunku subowego*/
	V_5 NCHAR(1), /*Strona z incjatyw ktrej nastpio rowzwizanie stosunku pracy*/
	
	VI_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZWUA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZWPA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 smallint NULL /*Wyrejestrowanie patnika - osoby prawnej / jednost*/,
	I_2 smallint NULL /*Korekta danych wyrejestrowania patnika skadek*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(3) NULL /*Kod przyczyny wyrejestrowania*/,
	III_2 datetime NULL /*Data wyrejestrowania*/,
	IV_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,

CONSTRAINT PK_ZUSZWPA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;


CREATE TABLE ZUSOSW  (
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 nvarchar(10) NULL /*NIP*/,
	I_2 nvarchar(14) NULL /*REGON*/,
	I_3 nvarchar(11) NULL /*PESEL*/,
	I_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	I_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	I_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	I_7 nvarchar(31) NULL /*Nazwisko*/,
	I_8 nvarchar(22) NULL /*Imi pierwsze*/,
	I_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	II_1 smallint NULL/*Owiadczam, e zamierzam przekaza raporty informacyjne*/,
	II_2 smallint NULL /*Odwouj owiadczenie o zamiarze przekazania raportw informacyjnych*/,
	III_1 DATETIME /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSOSW PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;

 
CREATE TABLE ZUSZUA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 smallint NULL /*Zgoszenie do ubezpiecze spoecznych i do ubezpie*/,
	I_2 nvarchar(1) NULL /*Zgoszenie zmiany / korekty danych osoby ubezpiecz*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(11) NULL /*PESEL*/,
	III_2 nvarchar(10) NULL /*NIP*/,
	III_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_5 nvarchar(31) NULL /*Nazwisko*/,
	III_6 nvarchar(22) NULL /*Imi pierwsze*/,
	III_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_1 nvarchar(22) NULL /*Imi drugie*/,
	IV_2 nvarchar(31) NULL /*Nazwisko rodowe*/,
	IV_3 nvarchar(22) NULL /*Obywatelstwo*/,
	IV_4 nvarchar(1) NULL /*Pe*/,
	V_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	V_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	V_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	VI_1 datetime NULL /*Data powstania obowizku ubezpieczenia (dd-mm-rrrr*/,
	VI_2 smallint NULL /*Osoba zgaszana podlega ubezpieczeniom Emerytalnem*/,
	VI_3 smallint NULL /*Osoba zgaszana podlega ubezpieczeniom Rentowym*/,
	VI_4 smallint NULL /*Osoba zgaszana podlega ubezpieczeniom Chorobowemu*/,
	VI_5 smallint NULL /*Osoba zgaszana podlega ubezpieczeniom Wypadkowemu*/,
	VII_1 datetime NULL /*Data powstania obowizku ubezpieczenia (dd-mm-rrrr*/,
	VII_2 nvarchar(3) NULL /*Kod oddziau NFZ*/,
	VIII_1 smallint NULL /*Wnosz o objcie ubezpieczeniami: Emerytalnym*/,
	VIII_2 datetime NULL /*Od dnia (dd-mm-rrrr)*/,
	VIII_3 smallint NULL /*Wnosz o objcie ubezpieczeniami: Rentowymi*/,
	VIII_4 datetime NULL /*Od dnia (dd-mm-rrrr)*/,
	VIII_5 smallint NULL /*Wnosz o objcie ubezpieczeniami: Chorobowym*/,
	VIII_6 datetime NULL /*Od dnia (dd-mm-rrrr)*/,
	IX_1 datetime NULL /*Data powstania obowizku ubezpieczenia (dd-mm-rrrr*/,
	IX_2 nvarchar(3) NULL /*Kod oddziau NFZ*/,
	X_1 nvarchar(7) NULL /*Kod wykonywanego zawodu*/,
	X_2 nvarchar(9) NULL /*Kod pracy w szczeglnych warunkach / w szczeglnym*/,
	X_3_1 datetime NULL /*Okres pracy w szczeglnych warunkach / w szczegln*/,
	X_3_2 datetime NULL /*Okres pracy w szczeglnych warunkach / w szczegln*/,
	XI_1 nvarchar(5) NULL /*Kod pocztowy*/,
	XI_2 nvarchar(26) NULL /*Miejscowo*/,
	XI_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	XI_4 nvarchar(30) NULL /*Ulica*/,
	XI_5 nvarchar(7) NULL /*Numer domu*/,
	XI_6 nvarchar(7) NULL /*Numer lokalu*/,
	XI_7 nvarchar(12) NULL /*Numer telefonu*/,
	XI_8 nvarchar(12) NULL /*Symbol pastwa*/,
	XII_1 nvarchar(5) NULL /*Kod pocztowy*/,
	XII_2 nvarchar(26) NULL /*Miejscowo*/,
	XII_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	XII_4 nvarchar(30) NULL /*Ulica*/,
	XII_5 nvarchar(7) NULL /*Numer domu*/,
	XII_6 nvarchar(7) NULL /*Numer lokalu*/,
	XII_7 nvarchar(12) NULL /*Numer telefonu*/,
	XII_8 nvarchar(12) NULL /*Symbol pastwa*/,
	XIII_1 nvarchar(5) NULL /*Kod pocztowy*/,
	XIII_2 nvarchar(26) NULL /*Miejscowo*/,
	XIII_3 nvarchar(30) NULL /*Ulica*/,
	XIII_4 nvarchar(7) NULL /*Numer domu*/,
	XIII_5 nvarchar(7) NULL /*Numer lokalu*/,
	XIII_6 nvarchar(5) NULL /*Skrytka pocztowa*/,
	XIII_7 nvarchar(12) NULL /*Numer telefonu*/,
	XIII_8 nvarchar(12) NULL /*Symbol pastwa*/,
	XIII_9 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	XIV_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSZUA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZSWA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1_1 int NULL /*Identyfikator Zgoszenia*/,
	I_1_2 date NULL /*Okres Informacji (rrrr)*/,
	I_2 datetime NULL /*Data nadania*/,
	I_3 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	VII_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZSWA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZPA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 smallint NULL /*Zgoszenie patnika skadek*/,
	I_2 nvarchar(1) NULL /*Zgoszenie zmiany / korekty danych patnika skade*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(31) NULL /*Nazwa skrcona*/,
	III_1 nvarchar(62) NULL /*Nazwa / Firma*/,
	III_2 smallint NULL /*Czy patnik jest jednostk budetow w rozumieniu */,
	III_3 smallint NULL /*Czy patnik jest zakadem budetowym lub gospodars*/,
	III_4 nvarchar(31) NULL /*Nazwa organu zaoycielskiego*/,
	III_5 smallint NULL /*Czy patnik podlega wpisowi do rejestru / ewidencj*/,
	III_6 datetime NULL /*Data wpisu do rejestru / ewidencji (dd-mm-rrrr)*/,
	III_7 nvarchar(15) NULL /*Numer wpisu do rejestru / ewidencji*/,
	III_8 nvarchar(72) NULL /*Nazwa organu rejestrowego / ewidencyjnego*/,
	III_9 datetime NULL /*Data powstania obowizku opacania skadek (dd-mm-*/,
	IV_1 nvarchar(36) NULL /*Numer rachunku*/,
	IV_2 smallint NULL /*Czy patnik posiada inne rachunki bankowe? Jeli t*/,
	V_1 nvarchar(5) NULL /*Kod pocztowy*/,
	V_2 nvarchar(26) NULL /*Miejscowo*/,
	V_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	V_4 nvarchar(30) NULL /*Ulica*/,
	V_5 nvarchar(7) NULL /*Numer domu*/,
	V_6 nvarchar(7) NULL /*Numer lokalu*/,
	V_7 nvarchar(12) NULL /*Numer telefonu*/,
	V_8 nvarchar(12) NULL /*Symbol pastwa*/,
	V_9 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	V_10 smallint NULL /*Czy patnik posiada inny adres prowadzenia dziaal*/,
	VI_1 nvarchar(5) NULL /*Kod pocztowy*/,
	VI_2 nvarchar(26) NULL /*Miejscowo*/,
	VI_3 nvarchar(30) NULL /*Ulica*/,
	VI_4 nvarchar(7) NULL /*Numer domu*/,
	VI_5 nvarchar(7) NULL /*Numer lokalu*/,
	VI_6 nvarchar(12) NULL /*Numer telefonu do teletransmisji*/,
	VI_7 nvarchar(5) NULL /*Skrytka pocztowa*/,
	VI_8 nvarchar(12) NULL /*Numer telefonu*/,
	VI_9 nvarchar(12) NULL /*Symbol pastwa*/,
	VI_10 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	VII_1 nvarchar(10) NULL /*NIP*/,
	VII_2 nvarchar(14) NULL /*REGON*/,
	VII_3 nvarchar(31) NULL /*Nazwa skrcona*/,
	VIII_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZPA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZIUA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 nvarchar(1) NULL /*Zgoszenie zmiany / korekty danych identyfikacyjny*/,
	I_2 datetime NULL /*Data nadania*/,
	I_3 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(11) NULL /*PESEL*/,
	III_2 nvarchar(10) NULL /*NIP*/,
	III_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_5 nvarchar(31) NULL /*Nazwisko*/,
	III_6 nvarchar(22) NULL /*Imi pierwsze*/,
	III_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_1 nvarchar(11) NULL /*PESEL*/,
	IV_2 nvarchar(10) NULL /*NIP*/,
	IV_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	IV_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	IV_5 nvarchar(31) NULL /*Nazwisko*/,
	IV_6 nvarchar(22) NULL /*Imi pierwsze*/,
	IV_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	V_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZIUA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZIPA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 nvarchar(1) NULL /*Zgoszenie zmiany / korekty danych identyfikacyjny*/,
	I_2 datetime NULL /*Data nadania*/,
	I_3 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(10) NULL /*NIP*/,
	III_2 nvarchar(14) NULL /*REGON*/,
	III_3 nvarchar(11) NULL /*PESEL*/,
	III_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	III_7 nvarchar(31) NULL /*Nazwisko*/,
	III_8 nvarchar(22) NULL /*Imi pierwsze*/,
	III_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZIPA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZFA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 smallint NULL /*Zgoszenie patnika skadek*/,
	I_2 nvarchar(1) NULL /*Zgoszenie zmiany / korekty danych patnika skade*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(22) NULL /*Imi drugie*/,
	III_2 nvarchar(26) NULL /*Miejsce urodzenia*/,
	III_3 nvarchar(22) NULL /*Obywatelstwo*/,
	IV_1 nvarchar(2) NULL /*Kod rodzaju uprawnienia*/,
	IV_2 nvarchar(15) NULL /*Numer uprawnienia*/,
	IV_3 nvarchar(72) NULL /*Nazwa organu wydajcego uprawnienie*/,
	IV_4 datetime NULL /*Data wydania uprawnienia (dd-mm-rrrr)*/,
	IV_5 datetime NULL /*Data powstania obowizku opacania skadek (dd-mm-*/,
	V_1 nvarchar(36) NULL /*Numer rachunku*/,
	V_2 smallint NULL /*Czy patnik posiada inne rachunki bankowe? Jeli t*/,
	VI_1 nvarchar(5) NULL /*Kod pocztowy*/,
	VI_2 nvarchar(26) NULL /*Miejscowo*/,
	VI_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	VI_4 nvarchar(30) NULL /*Ulica*/,
	VI_5 nvarchar(7) NULL /*Numer domu*/,
	VI_6 nvarchar(7) NULL /*Numer lokalu*/,
	VI_7 nvarchar(12) NULL /*Numer telefonu*/,
	VI_8 nvarchar(12) NULL /*Symbol pastwa*/,
	VI_9 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	VI_10 smallint NULL /*Czy patnik posiada inny adres prowadzenia dziaal*/,
	VII_1 nvarchar(5) NULL /*Kod pocztowy*/,
	VII_2 nvarchar(26) NULL /*Miejscowo*/,
	VII_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	VII_4 nvarchar(30) NULL /*Ulica*/,
	VII_5 nvarchar(7) NULL /*Numer domu*/,
	VII_6 nvarchar(7) NULL /*Numer lokalu*/,
	VII_7 nvarchar(12) NULL /*Numer telefonu*/,
	VII_8 nvarchar(12) NULL /*Symbol pastwa*/,
	VIII_1 nvarchar(5) NULL /*Kod pocztowy*/,
	VIII_2 nvarchar(26) NULL /*Miejscowo*/,
	VIII_3 nvarchar(30) NULL /*Ulica*/,
	VIII_4 nvarchar(7) NULL /*Numer domu*/,
	VIII_5 nvarchar(7) NULL /*Numer lokalu*/,
	VIII_6 nvarchar(12) NULL /*Numer telefonu do teletransmisji*/,
	VIII_7 nvarchar(5) NULL /*Skrytka pocztowa*/,
	VIII_8 nvarchar(12) NULL /*Numer telefonu*/,
	VIII_9 nvarchar(12) NULL /*Symbol pastwa*/,
	VIII_10 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	IX_1 nvarchar(10) NULL /*NIP*/,
	IX_2 nvarchar(14) NULL /*REGON*/,
	IX_3 nvarchar(31) NULL /*Nazwa skrcona*/,
	X_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZFA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZCNA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 datetime NULL /*Data nadania*/,
	I_2 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(11) NULL /*PESEL*/,
	III_2 nvarchar(10) NULL /*NIP*/,
	III_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_5 nvarchar(31) NULL /*Nazwisko*/,
	III_6 nvarchar(22) NULL /*Imi pierwsze*/,
	III_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	VI_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZCNA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZBA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 datetime NULL /*Data nadania*/,
	I_2 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IX_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZBA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZAA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 datetime NULL /*Data nadania*/,
	I_2 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IX_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZAA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSRZA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1_1 int NULL /*Identyfikator raportu (numer)*/,
	I_1_2 date NULL /*Okres rozliczeniowy raportu (mm/rrrr)*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	VIII_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
CONSTRAINT PK_ZUSRZA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSRSA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1_1 int NULL /*Identyfikator raportu (numer)*/,
	I_1_2 date NULL /*Okres rozliczeniowy raportu (mm/rrrr)*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	XI_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
CONSTRAINT PK_ZUSRSA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSRCA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1_1 int NULL /*Identyfikator raportu (numer)*/,
	I_1_2 date NULL /*Okres rozliczeniowy raportu (mm/rrrr)*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	V_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
CONSTRAINT PK_ZUSRCA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;

CREATE TABLE ZUSRPA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1_1 int NULL /*Identyfikator raportu (numer)*/,
	I_1_2 date NULL /*Okres rozliczeniowy raportu (mm/rrrr)*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
CONSTRAINT PK_ZUSRPA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;


CREATE TABLE ZUSRIA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1 smallint  NULL,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 NVARCHAR(31),
	III_2 NVARCHAR(22),
	III_3 NVARCHAR(1),
	III_4 NVARCHAR(11),
	IV_1 DATETIME,
	IV_2 NVARCHAR,
	IV_3 NVARCHAR,
	IV_4 NVARCHAR(255),
	IV_5 INTEGER,
	X1_1 smallint ,
	XII_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
CONSTRAINT PK_ZUSRIA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;

CREATE TABLE ZUSRIA_V(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,	
	V_1 INTEGER,
	V_2 INTEGER,
	V_3 DECIMAL(15,2),	
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRIA_V PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;

CREATE TABLE ZUSRIA_VI(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,	
	VI_1 INTEGER,
	VI_2 INTEGER,
	VI_3 DECIMAL(15,2),	
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRIA_VI PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;

CREATE TABLE ZUSRIA_VII(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,	
	VII_1 INTEGER,
	VII_2 INTEGER,
	VII_3 DECIMAL(15,2),	
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRIA_VII PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;

CREATE TABLE ZUSRIA_VIII(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	VIII_1 DATETIME,
	VIII_2 DATETIME,
	VIII_3_1 INTEGER,
	VIII_3_2 INTEGER,
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRIA_VIII PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;

CREATE TABLE ZUSRIA_IX(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	IX_1 DATETIME,
	IX_2 DATETIME,
	IX_3_1 INTEGER,
	IX_3_2 INTEGER,
	IX_4 smallint,	
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRIA_IX PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;

CREATE TABLE ZUSRIA_X(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,	
	X_2 DATETIME,
	X_3 DATETIME,
	X_4 smallint,
	X_5_1 INTEGER,
	X_5_2 INTEGER,
	X_6 VARCHAR(10),
	X_7 VARCHAR(10),
	X_8 NVARCHAR(36),
	X_9 NVARCHAR(36),
	X_10 VARCHAR(10),
	X_11 NVARCHAR(36),
	X_12 NVARCHAR(36),
	X_13 smallint,
	X_14 smallint,	
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRIA_X PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;

CREATE TABLE ZUSRIA_XI(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,	
	XI_1 NVARCHAR,
	XI_2 DATETIME,
	XI_3 DATETIME,
	XI_4_1 INTEGER,
	XI_4_2 INTEGER,
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRIA_XI PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;




 
CREATE TABLE ZUSIWA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1_1 int NULL /*Identyfikator informacji*/,
	I_1_2 date NULL /*Okres Informacji (rrrr)*/,
	I_2 nvarchar(6) NULL /*Kod terytorialny jednostki terenowej*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	I_5 datetime NULL /*Data wpywu*/,
	I_6 nvarchar(12) NULL /*Znak i numer decyzji pokontrolnej*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 int NULL /*Liczba ubezpieczonych*/,
	IV_1 nvarchar(5) NULL /*Rodzaj dziaalnoci wedug PKD*/,
	IV_2 int NULL /*Liczba poszkodowanych w wypadkach przy pracy oge*/,
	IV_3 int NULL /*Liczba poszkodowanych w wypadkach przy pracy mier*/,
	IV_4 int NULL /*Liczba zatrudnionych w warunkach zagroenia*/,
	V_1 nvarchar(5) NULL /*Kod pocztowy*/,
	V_2 nvarchar(26) NULL /*Miejscowo*/,
	V_3 nvarchar(30) NULL /*Ulica*/,
	V_4 nvarchar(7) NULL /*Numer domu*/,
	V_5 nvarchar(7) NULL /*Numer lokalu*/,
	V_6 nvarchar(12) NULL /*Numer telefonu do teletransmisji*/,
	V_7 nvarchar(5) NULL /*Skrytka pocztowa*/,
	V_8 nvarchar(12) NULL /*Numer telefonu*/,
	V_9 nvarchar(12) NULL /*Symbol pastwa*/,
	V_10 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	VI_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSIWA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSDRA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1 nvarchar(1) NULL /*Termin przysyania deklaracji i raportw DRA*/,
	I_2_1 int NULL /*Identyfikator deklaracji (numer)*/,
	I_2_2 date NULL /*Okres rozliczeniowy deklaracji (mm/rrrr)*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	I_5 nvarchar(12) NULL /*Znak i numer decyzji pokontrolnej*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 int NULL /*Liczba ubezpieczonych*/,
	III_2 nvarchar(1) NULL /*Wniosek pracodawcy o dofinansowanie skadek za oso*/,
	III_3 decimal(4,2) NULL /*Stopa procentowa skadek na ubezpieczenie wypadkow*/,
	IV_1 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sumy skadek*/,
	IV_2 decimal(11,2) NULL /*Skadki na ubezp. rent. Sumy skadek*/,
	IV_3 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sumy skadek*/,
	IV_4 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sk. finansowane przez: */,
	IV_5 decimal(11,2) NULL /*Skadki na ubezp. rent. Sk. finansowane przez: ub*/,
	IV_6 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sk. finansowane prz*/,
	IV_7 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sk. finansowane przez: */,
	IV_8 decimal(11,2) NULL /*Skadki na ubezp. rent. Sk. finansowane przez: p*/,
	IV_9 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sk. finansowane prz*/,
	IV_10 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sk. finansowane przez: */,
	IV_11 decimal(11,2) NULL /*Skadki na ubezp. rent. Sk. finansowane przez: bu*/,
	IV_12 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sk. finansowane prz*/,
	IV_13 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sk. finansowane przez: */,
	IV_14 decimal(11,2) NULL /*Skadki na ubezp. rent. Sk. finansowane przez: PF*/,
	IV_15 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sk. finansowane prz*/,
	IV_16 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sk. finansowane przez: */,
	IV_17 decimal(11,2) NULL /*Skadki na ubezp. rent. Sk. finansowane przez: Fu*/,
	IV_18 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sk. finansowane prz*/,
	IV_19 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sumy skadek*/,
	IV_20 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sumy skadek*/,
	IV_21 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp.*/,
	IV_22 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sk. finansowane przez: */,
	IV_23 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sk. finansowane przez: */,
	IV_24 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp. Sk. finansowane pr*/,
	IV_25 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sk. finansowane przez: */,
	IV_26 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sk. finansowane przez: */,
	IV_27 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp. Sk. finansowane pr*/,
	IV_28 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sk. finansowane przez: */,
	IV_29 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sk. finansowane przez: */,
	IV_30 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp. Sk. finansowane pr*/,
	IV_31 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sk. finansowane przez: */,
	IV_32 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sk. finansowane przez: */,
	IV_33 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp. Sk. finansowane pr*/,
	IV_34 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sk. finansowane przez: */,
	IV_35 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sk. finansowane przez: */,
	IV_36 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp. Sk. finansowane pr*/,
	IV_37 decimal(12,2) NULL /*Kwota skadek na ubezpieczenia spoeczne, ktre po*/,
	V_1 decimal(11,2) NULL /*Kwota wypaconych wiadcze z ubezpieczenia chorob*/,
	V_2 decimal(11,2) NULL /*Kwota wynagrodzenia nalenego patnikowi od wypac*/,
	V_3 decimal(11,2) NULL /*Kwota wypaconych wiadcze z ubezpieczenia wypadk*/,
	V_4 decimal(11,2) NULL /*Kwota wypaconych wiadcze finansowanych z budet*/,
	V_5 decimal(12,2) NULL /*aczna kwota do potrcenia (p.01 + p.02 + p.03 + p*/,
	VI_1 decimal(11,2) NULL /*Kwota nalenych skadek finansowana przez patnika*/,
	VI_2 decimal(11,2) NULL /*Kwota nalenych skadek finansowana przez ubezpiec*/,
	VI_3 decimal(11,2) NULL /*Kwota nalenych skadek finansowana przez Fundusz */,
	VI_4 decimal(11,2) NULL /*Kwota nalenych skadek finansowanych z budetu pa*/,
	VI_5 decimal(11,2) NULL /*Kwota nalenych skadek do przekazania przez patn*/,
	VI_6 decimal(10,2) NULL /*Kwota nalenego wynagrodzenia dla patnika*/,
	VI_7 decimal(12,2) NULL /*Kwota do zapaty (p.01 - p.04)*/,
	VII_1 decimal(11,2) NULL /*Kwota nalenych skadek na Fundusz Pracy*/,
	VII_2 decimal(11,2) NULL /*Kwota nalenych skadek na Fundusz Gwarantowanych */,
	VII_3 decimal(12,2) NULL /*Kwota do zapaty (p.01 + p.02)*/,
	VIII_1 int NULL /*Liczba pracownikw, za ktrych jest opacana skad*/,
	VIII_2 int NULL /*Liczba stanowisk pracy w szczeglnych warunkach lu*/,
	VIII_3 decimal(12,2) NULL /*Suma nalenych skadek na Fundusz Emerytur Pomosto*/,
	IX_1 NUMERIC(13,2),/*Kwota do zwrotu przez ZUS*/
	IX_2 NUMERIC(13,2),	/*Kwota do zapaty*/
	X_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	X_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	X_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	X_2 decimal(10,2) NULL /*Podstawa wymiaru skadek na ubezpieczenia emerytal*/,
	X_3 decimal(10,2) NULL /*Podstawa wymiaru skadek na ubezpieczenie chorobow*/,
	X_4 decimal(10,2) NULL /*Podstawa wymiaru skadek na ubezpieczenie wypadkow*/,
	X_5 decimal(10,2) NULL /*Podstawa wymiaru skadek na ubezpieczenie zdrowotn*/,
	X_6 nvarchar(1) NULL /*Informacja o przekroczeniu rocznej podstawy wymiar*/,
	XI_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSDRA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;
 
CREATE TABLE ZUSZSWA_III(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	III_A_1 smallint NULL /*Zgoszenie danych*/,
	III_A_2 smallint NULL /*Zgoszenie korekty danych*/,
	III_A_3 nvarchar(11) NULL /*PESEL*/,
	III_A_4 nvarchar(10) NULL /*NIP*/,
	III_A_5 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_A_6 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_A_7 nvarchar(31) NULL /*Nazwisko*/,
	III_A_8 nvarchar(22) NULL /*Imi pierwsze*/,
	III_A_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_B_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	III_B_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	III_B_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	III_B_2 nvarchar(3) NULL /*Kod pracy w szczeglnych warunkach / o szczeglnym*/,
	III_B_3 datetime NULL /*Okres pracy w szczeglnych warunkach / o szczegln*/,
	III_B_4 datetime NULL /*Okres pracy w szczeglnych warunkach / o szczegln*/,
	III_B_5_1 smallint NULL /*Wymiar czasu pracy (licznik)*/,
	III_B_5_2 smallint NULL /*Wymiar czasu pracy (mianownik)*/,
	III_B_6 nvarchar(3) NULL /*Kod pracy w szczeglnych warunkach / o szczeglnym*/,
	III_B_7 datetime NULL /*Okres pracy w szczeglnych warunkach / o szczegln*/,
	III_B_8 datetime NULL /*Okres pracy w szczeglnych warunkach / o szczegln*/,
	III_B_9_1 smallint NULL /*Wymiar czasu pracy (licznik)*/,
	III_B_9_2 smallint NULL /*Wymiar czasu pracy (mianownik)*/,
	III_B_10 nvarchar(3) NULL /*Kod pracy w szczeglnych warunkach / o szczeglnym*/,
	III_B_11 datetime NULL /*Okres pracy w szczeglnych warunkach / o szczegln*/,
	III_B_12 datetime NULL /*Okres pracy w szczeglnych warunkach / o szczegln*/,
	III_B_13_1 smallint NULL /*Wymiar czasu pracy (licznik)*/,
	III_B_13_2 smallint NULL /*Wymiar czasu pracy (mianownik)*/,
	III_B_14 nvarchar(3) NULL /*Kod pracy w szczeglnych warunkach / o szczeglnym*/,
	III_B_15 datetime NULL /*Okres pracy w szczeglnych warunkach / o szczegln*/,
	III_B_16 datetime NULL /*Okres pracy w szczeglnych warunkach / o szczegln*/,
	III_B_17_1 smallint NULL /*Wymiar czasu pracy (licznik)*/,
	III_B_17_2 smallint NULL /*Wymiar czasu pracy (mianownik)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZSWA_III PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;
 
CREATE TABLE ZUSZCNA_IV(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	IV_A_1 nvarchar(1) NULL /*Zgoszenie nowego czonka rodziny / wyrejestrowani*/,
	IV_A_2 datetime NULL /*Data uzyskania / utraty uprawnie do ubezpieczenia*/,
	IV_A_3 nvarchar(11) NULL /*PESEL*/,
	IV_A_4 nvarchar(10) NULL /*NIP*/,
	IV_A_5 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	IV_A_6 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	IV_A_7 nvarchar(31) NULL /*Nazwisko*/,
	IV_A_8 nvarchar(22) NULL /*Imi pierwsze*/,
	IV_A_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_A_10 nvarchar(2) NULL /*Kod stopnia pokrewiestwa / powinowactwa*/,
	IV_A_11 smallint NULL /*Czy pozostaje we wsplnym gospodarstwie domowym z */,
	IV_A_12 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	IV_B_1 nvarchar(5) NULL /*Kod pocztowy*/,
	IV_B_2 nvarchar(26) NULL /*Miejscowo*/,
	IV_B_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	IV_B_4 nvarchar(30) NULL /*Ulica*/,
	IV_B_5 nvarchar(7) NULL /*Numer domu*/,
	IV_B_6 nvarchar(7) NULL /*Numer lokalu*/,
	IV_B_7 nvarchar(12) NULL /*Numer telefonu*/,
	IV_B_8 nvarchar(12) NULL /*Symbol pastwa*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZCNA_IV PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;
 
CREATE TABLE ZUSZBA_III(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	III_1 nvarchar(1) NULL /*Nowy rachunek / zamknicie rachunku*/,
	III_2 nvarchar(36) NULL /*Numer rachunku*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZBA_III PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;
 
CREATE TABLE ZUSZAA_III(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	III_1 nvarchar(1) NULL /*Nowy adres / zakoczenie prowadzenia dziaalnoci */,
	III_2 nvarchar(5) NULL /*Kod pocztowy*/,
	III_3 nvarchar(26) NULL /*Miejscowo*/,
	III_4 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	III_5 nvarchar(30) NULL /*Ulica*/,
	III_6 nvarchar(7) NULL /*Numer domu*/,
	III_7 nvarchar(7) NULL /*Numer lokalu*/,
	III_8 nvarchar(12) NULL /*Numer telefonu*/,
	III_9 nvarchar(12) NULL /*Symbol pastwa*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZAA_III PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;
 
CREATE TABLE ZUSRZA_III(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	III_A_1 nvarchar(31) NULL /*Nazwisko*/,
	III_A_2 nvarchar(22) NULL /*Imi pierwsze*/,
	III_A_3 nvarchar(1) NULL /*Typ*/,
	III_A_4 nvarchar(11) NULL /*Identyfikator*/,
	III_B_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	III_B_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	III_B_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	III_B_2 decimal(8,2) NULL /*Podstawa wymiaru skadki*/,
	III_B_3 decimal(7,2) NULL /*Ubezpieczenie: Zdrowotne Kwota skadki finansowana*/,
	III_B_4 decimal(7,2) NULL /*Ubezpieczenie: Zdrowotne Kwota skadki finansowana*/,
	III_B_5 decimal(7,2) NULL /*Ubezpieczenie: Zdrowotne Kwota skadki finansowana*/,
	III_B_6 decimal(7,2) NULL /*Ubezpieczenie: Zdrowotne Kwota skadki finansowana*/,
	III_B_7 decimal(7,2) NULL /*Kwota skadki*/,
	TKL varchar(20) ,
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRZA_III PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;
 
CREATE TABLE ZUSRSA_III(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	III_A_1 nvarchar(31) NULL /*Nazwisko*/,
	III_A_2 nvarchar(22) NULL /*Imi pierwsze*/,
	III_A_3 nvarchar(1) NULL /*Typ*/,
	III_A_4 nvarchar(11) NULL /*Identyfikator*/,
	III_B_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	III_B_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	III_B_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	III_B_2 nvarchar(3) NULL /*Kod wiadczenia / przerwy*/,
	III_B_3 datetime NULL /*Okres od*/,
	III_B_4 datetime NULL /*Okres do*/,
	III_B_5 int NULL /*Liczba dni zasikowych / liczba wypat*/,
	III_B_6 decimal(7,2) NULL /*Kwota*/,
	TKL varchar(20) ,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSRSA_III PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;
 
CREATE TABLE ZUSRCA_III(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	III_A_1 nvarchar(31) NULL /*Nazwisko*/,
	III_A_2 nvarchar(22) NULL /*Imi pierwsze*/,
	III_A_3 nvarchar(1) NULL /*Typ*/,
	III_A_4 nvarchar(11) NULL /*Identyfikator*/,
	III_B_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	III_B_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	III_B_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	III_B_2 nvarchar(1) NULL /*Informacja o przekroczeniu rocznej podstawy wymiar*/,
	III_B_3_1 smallint NULL /*Wymiar czasu pracy (licznik)*/,
	III_B_3_2 smallint NULL /*Wymiar czasu pracy (mianownik)*/,
	III_B_4 decimal(8,2) NULL /*Ubezpieczenie: Emerytalne Rentowe Podstawa wymiaru*/,
	III_B_5 decimal(8,2) NULL /*Ubezpieczenie: Chorobowe Podstawa wymiaru skadki*/,
	III_B_6 decimal(8,2) NULL /*Ubezpieczenie: Wypadkowe Podstawa wymiaru skadki*/,
	III_B_7 decimal(7,2) NULL /*Ubezpieczenie: Emerytalne Kwota skadki finansowan*/,
	III_B_8 decimal(7,2) NULL /*Ubezpieczenie: Rentowe Kwota skadki finansowana p*/,
	III_B_9 decimal(7,2) NULL /*Ubezpieczenie: Chorobowe Kwota skadki finansowana*/,
	III_B_10 decimal(7,2) NULL /*Ubezpieczenie: Wypadkowe Kwota skadki finansowana*/,
	III_B_11 decimal(7,2) NULL /*Ubezpieczenie: Emerytalne Kwota skadki finansowan*/,
	III_B_12 decimal(7,2) NULL /*Ubezpieczenie: Rentowe Kwota skadki finansowana p*/,
	III_B_13 decimal(7,2) NULL /*Ubezpieczenie: Chorobowe Kwota skadki finansowana*/,
	III_B_14 decimal(7,2) NULL /*Ubezpieczenie: Wypadkowe Kwota skadki finansowana*/,
	III_B_15 decimal(7,2) NULL /*Ubezpieczenie: Emerytalne Kwota skadki finansowan*/,
	III_B_16 decimal(7,2) NULL /*Ubezpieczenie: Rentowe Kwota skadki finansowana p*/,
	III_B_17 decimal(7,2) NULL /*Ubezpieczenie: Chorobowe Kwota skadki finansowana*/,
	III_B_18 decimal(7,2) NULL /*Ubezpieczenie: Wypadkowe Kwota skadki finansowana*/,
	III_B_19 decimal(7,2) NULL /*Ubezpieczenie: Emerytalne Kwota skadki finansowan*/,
	III_B_20 decimal(7,2) NULL /*Ubezpieczenie: Rentowe Kwota skadki finansowana p*/,
	III_B_21 decimal(7,2) NULL /*Ubezpieczenie: Chorobowe Kwota skadki finansowana*/,
	III_B_22 decimal(7,2) NULL /*Ubezpieczenie: Wypadkowe Kwota skadki finansowana*/,
	III_B_23 decimal(7,2) NULL /*Ubezpieczenie: Emerytalne Kwota skadki finansowan*/,
	III_B_24 decimal(7,2) NULL /*Ubezpieczenie: Rentowe Kwota skadki finansowana p*/,
	III_B_25 decimal(7,2) NULL /*Ubezpieczenie: Chorobowe Kwota skadki finansowana*/,
	III_B_26 decimal(7,2) NULL /*Ubezpieczenie: Wypadkowe Kwota skadki finansowana*/,
	III_B_27 decimal(7,2) NULL /*Kwota obnienia podstawy wymiaru skadek na ubezpi*/,
	III_B_28 decimal(8,2) NULL /*czna kwota skadek*/,
	III_C_1 decimal(8,2) NULL /*Ubezpieczenie: Zdrowotne Podstawa wymiaru skadki*/,
	III_C_2 decimal(7,2) NULL /*Ubezpieczenie: Zdrowotne Kwota skadki finansowana*/,
	III_C_3 decimal(7,2) NULL /*Ubezpieczenie: Zdrowotne Kwota skadki finansowana*/,
	III_C_4 decimal(7,2) NULL /*Ubezpieczenie: Zdrowotne Kwota skadki finansowana*/,
	III_C_5 decimal(7,2) NULL /*Ubezpieczenie: Zdrowotne Kwota skadki finansowana*/,
	III_D_1 decimal(7,2) NULL /*Kwota wypaconego zasiku rodzinnego*/,
	III_D_2 decimal(7,2) NULL /*Kwota wypaconego zasiku wychowawczego*/,
	III_D_3 decimal(7,2) NULL /*Kwota wypaconego zasiku pielgnacyjnego*/,
	III_D_4 decimal(8,2) NULL /*czna kwota wypaconych zasikw*/,
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRCA_III PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;



CREATE TABLE DOKUMENT(
	GUIDKEDU uniqueidentifier NOT NULL,
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	KOLEJNOSC unsigned bigint NULL,
	NAZWA varchar(20),
 CONSTRAINT PK_DOKUMENT PRIMARY KEY  
(
	GUIDKEDU ASC,
	GUIDDOKUMENT ASC
)
)
;

CREATE TABLE BLAD_TMP(
	GUIDBLAD uniqueidentifier NOT NULL,
	CONSTRAINT PK_BLAD_TMP PRIMARY KEY  
	(
		GUIDBLAD ASC
	)
)
;

CREATE TABLE BLAD(
	GUIDBLAD uniqueidentifier NOT NULL,
	GUIDKEDU uniqueidentifier ,
	GUIDDOKUMENT uniqueidentifier ,
	ID_MIEJSCA bigint NULL,
	KOD nvarchar(10) NOT NULL,
	KLASA nchar(1) NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	BLOK smallint NULL,
	POLE smallint NULL,
	SEGMENT smallint NULL,
	ID_BLOKU int NULL,
	OPIS text NULL,
	CONSTRAINT PK_BLAD PRIMARY KEY  
	(
		GUIDBLAD ASC
	)
)
;

CREATE INDEX IX_BLAD_GUIDKEDU ON BLAD
(
	GUIDKEDU ASC
)
; 

CREATE INDEX IX_BLAD_GUIDDOKUMENT ON BLAD
(
	GUIDDOKUMENT ASC
)
;

CREATE TABLE MIEJSCE(
	GUIDMIEJSCE uniqueidentifier NOT NULL,
	GUIDBLAD uniqueidentifier NOT NULL,
	ID_OBIEKTU bigint NOT NULL,
	TYP nvarchar(50) NOT NULL,
	BLOK smallint NULL,
	POLE smallint NULL,
	SEGMENT smallint NULL,
	ID_BLOKU int NULL,
	CONSTRAINT PK_MIEJSCE PRIMARY KEY  
	(
		GUIDMIEJSCE ASC
	)
) 
;

CREATE INDEX IX_MIEJSCE_GUIDBLAD ON MIEJSCE
(
	GUIDBLAD ASC
)
;

CREATE TABLE TKL(
	GUIDKEDU uniqueidentifier NOT NULL,/*Identyfikator KEDU*/
	GUIDDOKUMENT uniqueidentifier,/*identyfikator dokumentu*/
	ID_BLOKU int,/*numer bloku powtarzalnego*/
	NUMER varchar(20)/*Numer TKL*/
)
;

CREATE INDEX IX_TKL_GUIDDOKUMENT ON TKL
(
	GUIDDOKUMENT ASC
)
;

CREATE INDEX IX_TKL_ID_BLOKU ON TKL
(
	ID_BLOKU ASC
)
;

CREATE INDEX IX_TKL_NUMER ON TKL
(
	NUMER ASC
)
;

CREATE INDEX IX_ZUSRCA_III_ID_UB_ZUS ON ZUSRCA_III
(
	ID_UB_ZUS ASC
)
;

CREATE INDEX IX_ZUSRZA_III_ID_UB_ZUS ON ZUSRZA_III
(
	ID_UB_ZUS ASC
)
;

CREATE INDEX IX_ZUSRSA_III_ID_UB_ZUS ON ZUSRSA_III
(
	ID_UB_ZUS ASC
)
;

/*Tabele danych patnika z repliki*/

CREATE TABLE PLATNIK_ZUS (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   NAZWASKR nvarchar(31) NULL,
   STATUSWR nchar(1) NULL,
   STATUSPT nchar(1) NULL,
   IDBIURARACH integer NULL,
   DATAOD datetime NULL,
   DATADO datetime NULL,
   ID_DOK_ZGL integer NULL,
   ID_DOK_WYR integer NULL,
   ID_UZYTKOWNIK integer NULL,
   ZKPRCHR nchar(1) NULL,
   DATA_UTW datetime NULL,
   DATARDZIAL datetime NULL,
   INSERTTMP integer NULL,
   ID_PL_ZUS integer NULL,
   CECHA_PLATNIKA nchar(1) NULL,
   DOK_ZGLOSZ nvarchar(5) NULL,
   NAZWA_SKR_B_RACH nvarchar(31) NULL,
   NIP_B_RACH nvarchar(10) NULL,
   REGON_B_RACH nvarchar(14) NULL,
   STATUS_AKTYWNOSCI nchar(1) NULL,
   STATUS_POTW_W_ZUS nchar(1) NULL,
   ZNACZNIK_CZASU datetime NULL,
   DATA_POTW_W_ZUS datetime NULL,
   STATUS_WER_AUT nchar(1) NULL,
   SKROT_DANYCH nvarchar(40) NULL,
   NR_DZIAL smallint NULL,
   LICZBA_UBEZP integer NULL
)
;

CREATE TABLE PLATN_ADRES (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NOT NULL,
   ID_DOKUMENT integer NULL,
   TYP_ADRESU nchar(1) NULL,
   KODPOCZTOWY nvarchar(5) NULL,
   MIEJSCOWOSC nvarchar(26) NULL,
   GMINA nvarchar(26) NULL,
   ULICA nvarchar(30) NULL,
   NUMERDOMU nvarchar(7) NULL,
   NUMERLOKALU nvarchar(7) NULL,
   SKRPOCZTOWA nvarchar(5) NULL,
   TELEFON nvarchar(12) NULL,
   TELDOTELETR nvarchar(12) NULL,
   FAKS nvarchar(12) NULL,
   ADRPOCZTYEL nvarchar(30) NULL,
   WOJEWODZTWO nvarchar(26) NULL,
   STATUS_DANE nchar(1) NULL,
   DATAOD datetime NULL,
   INSERTTMP integer NULL,
   ID_PL_ZUS integer NULL
)
;

CREATE TABLE PLATN_IDENT (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NOT NULL,
   ID_DOK_ZGL integer NULL,
   NIP nvarchar(10) NULL,
   REGON nvarchar(14) NULL,
   PESEL nvarchar(11) NULL,
   RODZDOK nchar(1) NULL,
   SERIANRDOK nvarchar(9) NULL,
   NAZWASKR nvarchar(31) NULL,
   NAZWISKO nvarchar(31) NULL,
   IMIEPIERW nvarchar(22) NULL,
   DATAURODZ datetime NULL,
   NAZWAFIRMA nvarchar(62) NULL,
   TYP_PLATNIKA nchar(1) NULL,
   STATUS_DANE nchar(1) NULL,
   DATAOD datetime NULL,
   TYP_BLOK nchar(1) NULL,
   INSERTTMP integer NULL,
   ID_PL_ZUS integer NULL,
   ZRODLO_DANYCH nvarchar(50) NULL
)
;

CREATE TABLE PLATN_RACHBANK (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NOT NULL,
   ID_DOKUMENT integer NULL,
   NR_RACH_BANK nvarchar(36) NULL,
   KONTO_UBEZP nchar(1) NULL,
   DATAOD datetime NULL,
   STATUS_DANE nchar(1) NULL,
   INSERTTMP integer NULL,
   ID_PL_ZUS integer NULL
)
;

CREATE TABLE PLATN_DANEROZL (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NOT NULL,
   NAZWA nvarchar(16) NULL,
   WARTOSC nvarchar(8) NULL,
   DATAOD datetime NULL,
   DATADO datetime NULL,
   STATUS_DANE nchar(1) NULL,
   INSERTTMP integer NULL,
   ID_PL_ZUS integer NULL,
   ZAKRES_NUMEROW_DEKLARACJI smallint NULL,
   ZRODLO nchar(1) NULL
)
;

CREATE TABLE PLATN_OBOWOPLSKL (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NOT NULL,
   ID_PL_ZUS integer NULL, 
   DATAOD datetime NULL,
   DATADO datetime NULL,
   STATUS_DANE nchar(1) NULL,
   INSERTTMP integer NULL
)
;

CREATE TABLE PLATN_OBOWIWA (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NOT NULL,
   ID_PL_ZUS integer NULL, 
   ROK datetime NULL,
   STATUS_ZAPISU nchar(1) NULL,
   DATA_USTALENIA_ZAPISU datetime NULL,
   STATUS_DANE nchar(1) NULL,
   INSERTTMP integer NULL
)
;

CREATE TABLE PLATN_STATUS (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NOT NULL,
   ID_PL_ZUS integer NULL, 
   DATAOD datetime NULL,
   DATADO datetime NULL,
   WARTOSC nchar(1) NULL,
   STATUS_DANE nchar(1) NULL,
   INSERTTMP integer NULL
)
;

CREATE TABLE PLATN_IWA (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NOT NULL,
   ID_PL_ZUS integer NULL,
   I_1_1IDINFOR integer NULL,
   I_1_2OKRINFOR datetime NULL,
   VI_1_DATAWYPEL datetime NULL,
   INSERTTMP integer NULL
)
;
   
CREATE TABLE PLATN_ZSWA (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NOT NULL,
   ID_PL_ZUS integer NULL,
   I_1_1IDZGLOSZ integer NULL,
   I_1_2OKRESZGL datetime NULL,
   INSERTTMP integer NULL
)
;

/*Tabele danych ubezpieczonego z repliki*/

CREATE TABLE UBEZPIECZONY_ZUS (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NOT NULL,
   ATRYBUT_I integer NULL,
   ATRYBUT_II integer NULL,
   STATUSWR nchar(1) NULL,
   STATUSPT nchar(1) NULL,
   ID_UZYTKOWNIK integer NULL,
   DATA_UTW datetime NULL,
   INSERTTMP integer NULL,
   ID_PL_ZUS integer NULL,
   ID_UB_ZUS integer NULL,
   STATUS_POTW_W_ZUS nchar(1) NULL,
   ZNACZNIK_CZASU datetime NULL,
   DATA_POTW_W_ZUS datetime NULL,
   STATUS_WER_AUT nchar(1) NULL,
   SKROT_DANYCH nvarchar(40) NULL
)
;

CREATE TABLE UBEZP_ADRES (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_UBEZPIECZONY integer NOT NULL,
   ID_DOKUMENT integer NULL,
   TYP_ADRESU nchar(1) NULL,
   KODPOCZTOWY nvarchar(5) NULL,
   MIEJSCOWOSC nvarchar(26) NULL,
   GMINA nvarchar(26) NULL,
   ULICA nvarchar(30) NULL,
   NUMERDOMU nvarchar(7) NULL,
   NUMERLOKALU nvarchar(7) NULL,
   SKRPOCZTOWA nvarchar(5) NULL,
   TELEFON nvarchar(12) NULL,
   FAKS nvarchar(12) NULL,
   ADRPOCZTYEL nvarchar(30) NULL,
   STATUS_DANE nchar(1) NULL,
   DATAOD datetime NULL,
   INSERTTMP integer NULL,
   ID_PL_ZUS integer NULL,
   ID_UB_ZUS integer NULL
)
;

CREATE TABLE UBEZP_IDENT (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_UBEZPIECZONY integer NOT NULL,
   ID_UBEZPIECZONY_SCAL integer NULL,
   ID_SDWIUBEZPIECZONY integer NULL,
   ID_DOKUMENT integer NULL,
   ZRODLO_DANYCH nvarchar(50) NULL,
   PESEL nvarchar(11) NULL,
   NIP nvarchar(10) NULL,
   RODZDOK nchar(1) NULL,
   SERIANRDOK nvarchar(9) NULL,
   NAZWISKO nvarchar(31) NULL,
   IMIEPIERW nvarchar(22) NULL,
   DATAURODZ datetime NULL,
   STATUS_DANE nchar(1) NULL,
   DATAOD datetime NULL,
   TYP_BLOK nchar(1) NULL,
   INSERTTMP integer NULL,
   ID_PL_ZUS integer NULL,
   ID_UB_ZUS integer NULL
)
;

CREATE TABLE UBEZP_KOD_PRACY (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_UBEZPIECZONY integer NOT NULL,
   KODTYTUB nvarchar(4) NULL,
   PRDOEM nchar(1) NULL,
   STNIEP nchar(1) NULL,
   KODPRSZW nvarchar(3) NULL,
   DATAOD datetime NULL,
   DATADO datetime NULL,
   WYMCZPRL nvarchar(3) NULL,
   WYMCZPRM nvarchar(3) NULL,
   INSERTTMP integer NULL,
   ID_PL_ZUS integer NULL,
   ID_UB_ZUS integer NULL
)
;

CREATE TABLE UBEZP_INNE (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_UBEZPIECZONY integer NOT NULL,
   ID_DOKUMENT integer NULL,
   KODKASY nvarchar(3) NULL,
   DATA_DOK datetime NULL,
   ID_DOKUMENT_OBYW integer NULL,
   OBYWATELSTWO nvarchar(22) NULL,
   DATA_DOK_OBYW datetime NULL,
   STATUS_DANE nchar(1) NULL,
   INSERTTMP integer NULL,
   ID_PL_ZUS integer NULL,
   ID_UB_ZUS integer NULL,
   DATA_ZGONU datetime NULL,
   DATA_AKT_DATY_ZGONU datetime NULL,
   ZRODLO_ZGONU nchar(1) NULL,
   IMIEDRUGIE nvarchar(22) NULL,
   NAZWISKOROD nvarchar(31) NULL,
   PLEC nchar(1) NULL,
   CZY_RIA_UBEZP NCHAR(1)
)
;

CREATE TABLE UBEZP_CZLONEK_RODZINY (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_UBEZPIECZONY integer NOT NULL,
   ID_PL_ZUS integer NULL,
   ID_UB_ZUS integer NULL,
   IMIEPIERW nvarchar(22) NULL,
   NAZWISKO nvarchar(31) NULL,
   NIP nvarchar(10) NULL,
   PESEL nvarchar(11) NULL,
   RODZDOK nchar(1) NULL,
   SERIANRDOK nvarchar(9) NULL,
   STNIEP nchar(1) NULL,
   KODSTPOKR nchar(2) NULL,
   POGOSPZUB nchar(1) NULL,
   DATAURODZ datetime NULL,
   DATA_UZYSKANIA_UPRAWNIEN datetime NULL,
   DATA_UTRATY_UPRAWNIEN datetime NULL,
   INSERTTMP integer NULL
)
;

CREATE TABLE UBEZP_30KROTNOSC (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_UBEZPIECZONY integer NOT NULL,
   ID_PL_ZUS integer NULL,
   ID_UB_ZUS integer NULL,
   ROK smallint NULL,
   MIESIAC_PRZEKROCZENIA smallint NULL,
   INSERTTMP integer NULL
)
;

CREATE TABLE UBEZP_PODLEGANIE (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_UBEZPIECZONY integer NOT NULL,
   ID_PL_ZUS integer NULL,
   ID_UB_ZUS integer NULL,
   KODTYTUB nvarchar(4) NULL,
   PRDOEM nchar(1) NULL,
   STNIEP nchar(1) NULL,
   DATAOD datetime NULL,
   DATADO datetime NULL,
   EMER_PODLEGANIE nchar(1) NULL,
   RENT_PODLEGANIE nchar(1) NULL,
   CHOR_PODLEGANIE nchar(1) NULL,
   WYP_PODLEGANIE nchar(1) NULL,
   ZDROW_PODLEGANIE nchar(1) NULL,
   NUMER_SCHEMATU integer NULL,
   TYP_DOK_WYREJ integer NULL,
   DATA_WYPELDOKWYREJ datetime NULL,
   ZWUA_V_DATAROZWYGSTPS datetime NULL,   
   LICZBA_DNI_DZIAL INTEGER NULL,
   ROK_UST_DNI_DZIAL smallint NULL,
   INSERTTMP integer NULL
)
;

CREATE TABLE UBEZP_INDSCHEMAT (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   NUMER_SCHEMATU integer NULL,
   RODZAJ nchar(1) NULL,
   EMER_PODLEGANIE nchar(1) NULL,
   EMER_ZR1 nvarchar(2) NULL,
   EMER_PROC1 numeric(5,4) NULL,
   EMER_ZR2 nvarchar(2) NULL,
   EMER_PROC2 numeric(5,4) NULL,
   RENT_PODLEGANIE nchar(1) NULL,
   RENT_ZR1 nvarchar(2) NULL,
   RENT_PROC1 numeric(5,4) NULL,
   RENT_ZR2 nvarchar(2) NULL,
   RENT_PROC2 numeric(5,4) NULL,
   CHOR_PODLEGANIE nchar(1) NULL,
   CHOR_ZR1 nvarchar(2) NULL,
   WYP_PODLEGANIE nchar(1) NULL,
   WYP_ZR1 nvarchar(2) NULL,
   WYP_PROC1 numeric(5,4) NULL,
   WYP_ZR2 nvarchar(2) NULL,
   WYP_PROC2 numeric(5,4) NULL,
   ZDROW_PODLEGANIE nchar(1) NULL,
   ZDROW_ZR1 nvarchar(2) NULL,
   INSERTTMP integer NULL
)
;  

/*Tabele danych kompletu logicznego z repliki*/

CREATE TABLE KOMPLET_DOKROZL ( 
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_PLATNIK integer NULL,
   ID_PL_ZUS integer NOT NULL,
   ID_KOMPL_ZUS integer NULL,
   NR_KOMPLETU integer NULL,
   OKRES_ROZLICZ datetime NULL,
   ZAKRES smallint NULL,
   PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
   ZNACZNIK_CZASU datetime NULL,
   DATA_POTW_W_ZUS datetime NULL,
   SKROT_DANYCH nvarchar(40) NULL,
   INSERTTMP integer NULL
)
;

CREATE TABLE DOKROZL_DEKLARACJA (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,	
   ID_DOKUMENT integer NULL,
   ID_PLATNIK integer NULL,
   ID_KOMPLET integer NULL,
   ID_WDR_ZUS integer NULL,
   ID_DOK_ZUS integer NULL,
   ID_PL_ZUS integer NULL,
   ID_KOMPL_ZUS integer NULL,
   PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
   STATUS_KONTROLI nchar(1) NULL,
   I_2_1 integer NULL,
   I_2_2 datetime NULL,
   III_1 integer NULL,
   III_2 nchar(1) NULL,
   III_3 numeric(5,2) NULL,
   IV_1 numeric(15,2) NULL,
   IV_2 numeric(15,2) NULL,
   IV_3 numeric(15,2) NULL,
   IV_4 numeric(15,2) NULL,
   IV_5 numeric(15,2) NULL,
   IV_6 numeric(15,2) NULL,
   IV_7 numeric(15,2) NULL,
   IV_8 numeric(15,2) NULL,
   IV_9 numeric(15,2) NULL,
   IV_10 numeric(15,2) NULL,
   IV_11 numeric(15,2) NULL,
   IV_12 numeric(15,2) NULL,
   IV_13 numeric(15,2) NULL,
   IV_14 numeric(15,2) NULL,
   IV_15 numeric(15,2) NULL,
   IV_16 numeric(15,2) NULL,
   IV_17 numeric(15,2) NULL,
   IV_18 numeric(15,2) NULL,
   IV_19 numeric(15,2) NULL,
   IV_20 numeric(15,2) NULL,
   IV_21 numeric(15,2) NULL,
   IV_22 numeric(15,2) NULL,
   IV_23 numeric(15,2) NULL,
   IV_24 numeric(15,2) NULL,
   IV_25 numeric(15,2) NULL,
   IV_26 numeric(15,2) NULL,
   IV_27 numeric(15,2) NULL,
   IV_28 numeric(15,2) NULL,
   IV_29 numeric(15,2) NULL,
   IV_30 numeric(15,2) NULL,
   IV_31 numeric(15,2) NULL,
   IV_32 numeric(15,2) NULL,
   IV_33 numeric(15,2) NULL,
   IV_34 numeric(15,2) NULL,
   IV_35 numeric(15,2) NULL,
   IV_36 numeric(15,2) NULL,
   IV_37 numeric(15,2) NULL,
   V_1 numeric(15,2) NULL,
   V_2 numeric(15,2) NULL,
   V_3 numeric(15,2) NULL,
   V_4 numeric(15,2) NULL,
   V_5 numeric(15,2) NULL,
   VI_1 numeric(15,2) NULL,
   VI_2 numeric(15,2) NULL,
   VII_1 numeric(15,2) NULL,
   VII_2 numeric(15,2) NULL,
   VII_3 numeric(15,2) NULL,
   VII_4 numeric(15,2) NULL,
   VII_5 numeric(15,2) NULL,
   VII_6 numeric(15,2) NULL,
   VII_7 numeric(15,2) NULL,
   VIII_1 numeric(15,2) NULL,
   VIII_2 numeric(15,2) NULL,
   VIII_3 numeric(15,2) NULL,
   IX_1 integer NULL,
   IX_2 integer NULL,
   IX_3 numeric(15,2) NULL,
	IX_KWOTA_DO_ZWROTU numeric(13,2) NULL,
	IX_KWOTA_DO_ZAPL numeric(13,2) NULL,
   X_1_1 nvarchar(4) NULL,
   X_1_2 nchar(1) NULL,
   X_1_3 nchar(1) NULL,
   X_2 numeric(15,2) NULL,
   X_3 numeric(15,2) NULL,
   X_4 numeric(15,2) NULL,
   X_5 numeric(15,2) NULL,
   X_6 nchar(1) NULL,
   INSERTTMP integer NULL,
   TKL varchar(20),
   TKL1 varchar(20),
   KOLEJKA char(1) default '0'
)
;

CREATE TABLE DOKROZL_RAPORT (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_DOKUMENT integer NULL,
   ID_PLATNIK integer NULL,
   ID_KOMPLET integer NULL,
   ID_DOK_ZUS integer NULL,
   ID_PL_ZUS integer NULL,
   ID_KOMPL_ZUS integer NULL,
   PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
   STATUS_KONTROLI nchar(1) NULL,
   TYP integer NOT NULL,
   I_1_1 integer NULL,
   I_1_2 datetime NULL,
   INSERTTMP integer NULL,
   TKL varchar(20),
   TKL1 varchar(20),
   KOLEJKA char(1) default '0'
)
;

CREATE TABLE UBEZP_SKLAD (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_DOKUMENT integer NULL,
   ID_PLATNIK integer NULL,
   ID_UBEZPIECZONY integer NULL,
   ID_DOK_ZUS integer NULL,
   NR_PODDOKUMENTU integer NULL,
   ID_PL_ZUS integer NULL,
   ID_UB_ZUS integer NULL,
   STATUS_KONTROLI nchar(1) NULL,
   TYP integer NOT NULL NULL,
   III_A_1 nvarchar(31) NULL,
   III_A_2 nvarchar(22) NULL,
   III_A_3 nchar(1) NULL,
   III_A_4 nvarchar(11) NULL,
   III_B_1_1 nvarchar(4) NULL,
   III_B_1_2 nchar(1) NULL,
   III_B_1_3 nchar(1) NULL,
   III_B_2 nchar(1) NULL,
   III_B_3_1 smallint NULL,
   III_B_3_2 smallint NULL,
   III_B_4 numeric(15,2) NULL,
   III_B_5 numeric(15,2) NULL,
   III_B_6 numeric(15,2) NULL,
   III_B_7 numeric(15,2) NULL,
   III_B_8 numeric(15,2) NULL,
   III_B_9 numeric(15,2) NULL,
   III_B_10 numeric(15,2) NULL,
   III_B_11 numeric(15,2) NULL,
   III_B_12 numeric(15,2) NULL,
   III_B_13 numeric(15,2) NULL,
   III_B_14 numeric(15,2) NULL,
   III_B_15 numeric(15,2) NULL,
   III_B_16 numeric(15,2) NULL,
   III_B_17 numeric(15,2) NULL,
   III_B_18 numeric(15,2) NULL,
   III_B_19 numeric(15,2) NULL,
   III_B_20 numeric(15,2) NULL,
   III_B_21 numeric(15,2) NULL,
   III_B_22 numeric(15,2) NULL,
   III_B_23 numeric(15,2) NULL,
   III_B_24 numeric(15,2) NULL,
   III_B_25 numeric(15,2) NULL,
   III_B_26 numeric(15,2) NULL,
   III_B_27 numeric(15,2) NULL,
   III_B_28 numeric(15,2) NULL,
   III_C_1 numeric(15,2) NULL,
   III_C_2 numeric(15,2) NULL,
   III_C_3 numeric(15,2) NULL,
   III_C_4 numeric(15,2) NULL,
   III_C_5 numeric(15,2) NULL,
   III_D_1 numeric(15,2) NULL,
   III_D_2 numeric(15,2) NULL,
   III_D_3 numeric(15,2) NULL,
   III_D_4 numeric(15,2) NULL,
   INSERTTMP integer NULL,
   TKL varchar(20),
   TKL1 varchar(20),
   KOLEJKA char(1) default '0'
)
;

CREATE TABLE UBEZP_SWIAD (
   ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
   ID_DOKUMENT integer NULL,
   ID_PLATNIK integer NULL,
   ID_UBEZPIECZONY integer NULL,
   ID_DOK_ZUS integer NULL,
   NR_PODDOKUMENTU integer NULL,
   ID_PL_ZUS integer NULL,
   ID_UB_ZUS integer NULL,
   STATUS_KONTROLI nchar(1) NULL,
   III_A_1 nvarchar(31) NULL,
   III_A_2 nvarchar(22) NULL,
   III_A_3 nchar(1) NULL,
   III_A_4 nvarchar(11) NULL,
   III_B_1_1 nvarchar(4) NULL,
   III_B_1_2 nchar(1) NULL,
   III_B_1_3 nchar(1) NULL,
   III_B_2 nvarchar(3) NULL,
   III_B_3 datetime NULL,
   III_B_4 datetime NULL,
   III_B_5 integer NULL,
   III_B_6 numeric(15,2) NULL,
   INSERTTMP integer NULL,
   TKL varchar(20),
   TKL1 varchar(20),
   KOLEJKA char(1) default '0'
)
;

/*Tabele inne*/

CREATE TABLE ZUSDOKPL(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 nvarchar(36) NULL /*Numer rachunku ZUS*/,
	I_2 int NULL /*Zakres*/,
	II_1 nvarchar(20) NULL /*Typ dokumentu*/,
	II_2 nvarchar(15) NULL /*Kwota*/,
	III_1 nvarchar(54) NULL /*Nazwa zleceniodawcy*/,
	III_2 nvarchar(36) NULL /*Rachunek zleceniodawcy*/,
	KOREKTA TEXT,
CONSTRAINT PK_DOKPL PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;

CREATE TABLE ZUSAKU(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 nvarchar(11) NULL /*PESEL*/,
	I_2 nvarchar(10) NULL /*NIP*/,
	I_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	I_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	I_5 nvarchar(31) NULL /*Nazwisko*/,
	I_6 nvarchar(22) NULL /*Imi pierwsze*/,
	I_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	I_8 nvarchar(32) NULL /*Atrybut I  (seria A)*/,
	I_9 nvarchar(32) NULL /*Atrybut II (seria A)*/,
	I_10 nvarchar(22) NULL /*Obywatelstwo*/,
	II_1 nvarchar(3) NULL /*Kod oddziau NFZ*/,
	III_1 nvarchar(5) NULL /*Kod pocztowy*/,
	III_2 nvarchar(26) NULL /*Miejscowo*/,
	III_3 nvarchar(26) NULL /*Gmina*/,
	III_4 nvarchar(30) NULL /*Ulica*/,
	III_5 nvarchar(7) NULL /*Numer domu*/,
	III_6 nvarchar(7) NULL /*Numer lokalu*/,
	III_7 nvarchar(12) NULL /*Numer telefonu*/,
	III_8 nvarchar(12) NULL /*Symbol pastwa*/,
	IV_1 nvarchar(5) NULL /*Kod pocztowy*/,
	IV_2 nvarchar(26) NULL /*Miejscowo*/,
	IV_3 nvarchar(26) NULL /*Gmina*/,
	IV_4 nvarchar(30) NULL /*Ulica*/,
	IV_5 nvarchar(7) NULL /*Numer domu*/,
	IV_6 nvarchar(7) NULL /*Numer lokalu*/,
	IV_7 nvarchar(12) NULL /*Numer telefonu*/,
	IV_8 nvarchar(12) NULL /*Symbol pastwa*/,
	V_1 nvarchar(5) NULL /*Kod pocztowy*/,
	V_2 nvarchar(26) NULL /*Miejscowo*/,
	V_3 nvarchar(30) NULL /*Ulica*/,
	V_4 nvarchar(7) NULL /*Numer domu*/,
	V_5 nvarchar(7) NULL /*Numer lokalu*/,
	V_6 nvarchar(5) NULL /*Skrytka pocztowa*/,
	V_7 nvarchar(12) NULL /*Numer telefonu*/,
	V_8 nvarchar(12) NULL /*Symbol pastwa*/,
	V_9 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	KOREKTA TEXT,
CONSTRAINT PK_AKU PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;

CREATE TABLE ZUSAKP(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 nvarchar(10) NULL /*NIP*/,
	I_2 nvarchar(14) NULL /*REGON*/,
	I_3 nvarchar(11) NULL /*PESEL*/,
	I_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	I_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	I_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	I_7 nvarchar(31) NULL /*Nazwisko*/,
	I_8 nvarchar(22) NULL /*Imi pierwsze*/,
	I_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	I_10 nvarchar(1) NULL /*Typ Patnika (seria A)*/,
	I_11 datetime NULL /*Data od (dla danych identyfikacyjnych)*/,
	II_1 datetime NULL /*Data rozpoczcia wykonywania dziaalnoci*/,
	III_1 nvarchar(5) NULL /*Kod pocztowy*/,
	III_2 nvarchar(26) NULL /*Miejscowo*/,
	III_3 nvarchar(26) NULL /*Gmina*/,
	III_4 nvarchar(30) NULL /*Ulica*/,
	III_5 nvarchar(7) NULL /*Numer domu*/,
	III_6 nvarchar(7) NULL /*Numer lokalu*/,
	III_7 nvarchar(12) NULL /*Numer telefonu*/,
	III_8 nvarchar(12) NULL /*Symbol pastwa*/,
	III_9 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	III_10 nvarchar(26) NULL /*Wojewdztwo*/,
	IV_1 nvarchar(5) NULL /*Kod pocztowy*/,
	IV_2 nvarchar(26) NULL /*Miejscowo*/,
	IV_3 nvarchar(30) NULL /*Ulica*/,
	IV_4 nvarchar(7) NULL /*Numer domu*/,
	IV_5 nvarchar(7) NULL /*Numer lokalu*/,
	IV_6 nvarchar(12) NULL /*Numer telefonu do teletransmisji*/,
	IV_7 nvarchar(5) NULL /*Skrytka pocztowa*/,
	IV_8 nvarchar(12) NULL /*Numer telefonu*/,
	IV_9 nvarchar(12) NULL /*Symbol pastwa*/,
	IV_10 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	IV_11 nvarchar(26) NULL /*Wojewdztwo*/,
	VI_1 decimal(3,2) NULL /*Stopa procentowa skadek na ubezpieczenie wypadkow*/,
	VI_2 nvarchar(62) NULL /*Nazwa / Firma (zgodnie z aktem prawnym konstytuuj*/,
	VI_3 smallint NULL /*Zakad pracy chronionej lub aktywnoci zawodowej*/,
	KOREKTA TEXT,
CONSTRAINT PK_AKP PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;

CREATE TABLE ZUSAKU_VI(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	VI_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	VI_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	VI_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	VI_2 nvarchar(3) NULL /*Kod pracy w szczeglnych warunkach / o szczeglnym*/,
	VI_3 datetime NULL /*Okres pracy w szczeglnych warunkach / o szczegln*/,
	VI_4 datetime NULL /*Okres pracy w szczeglnych warunkach / o szczegln*/,
	VI_5_1 smallint NULL /*Wymiar czasu pracy (licznik)*/,
	VI_5_2 smallint NULL /*Wymiar czasu pracy (mianownik)*/,
CONSTRAINT PK_AKU_VI PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;

CREATE TABLE ZUSAKP_V(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	V_1_1 nvarchar(36) NULL /*Numer rachunku bankowego*/,
CONSTRAINT PK_AKP_V PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;


CREATE TABLE ZUSAKP_VII(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_PL_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	VII_1_1 nvarchar(36) NULL /*Numer rachunku bankowego*/,
	VII_2 int NULL /*zakres*/,
CONSTRAINT PK_AKP_VII PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;

CREATE TABLE K_ZUSZCNA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUSPT nchar(1) NULL,
	I_1 datetime NULL /*Data nadania*/,
	I_2 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(11) NULL /*PESEL*/,
	III_2 nvarchar(10) NULL /*NIP*/,
	III_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_5 nvarchar(31) NULL /*Nazwisko*/,
	III_6 nvarchar(22) NULL /*Imi pierwsze*/,
	III_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	VI_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT
-- CONSTRAINT PK_K_ZUSZCNA PRIMARY KEY 
-- (
	-- GUIDDOKUMENT ASC
-- )
)
;

CREATE TABLE K_ZUSZWUA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUSPT nchar(1) NULL,
	I_1 char(1) NULL /*Wyrejestrowanie z ubezpiecze spoecznych i ubezpi*/,
	I_2 char(1) NULL /*Zgoszenie korekty danych o wyrejestrowaniu z ubez*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(11) NULL /*PESEL*/,
	III_2 nvarchar(10) NULL /*NIP*/,
	III_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_5 nvarchar(31) NULL /*Nazwisko*/,
	III_6 nvarchar(22) NULL /*Imi pierwsze*/,
	III_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	IV_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	IV_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	IV_2 datetime NULL /*Od dnia (dd-mm-rrrr)*/,
	IV_3 nvarchar(3) NULL /*Kod przyczyny wyrejestrowania*/,
	V_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,

	V_DATAROZWYGSTPS DATETIME,
	V_KODROZWYGSTPS CHAR(3),
	V_KODPPROWYSTPS CHAR(3),
	V_PODPRAWROWYSTPS NVARCHAR(180),
	V_STRINICJROZWISTP CHAR(1),
	
	KOREKTA TEXT
-- CONSTRAINT PK_K_ZUSZWUA PRIMARY KEY 
-- (
	-- GUIDDOKUMENT ASC
-- )
)
;

CREATE TABLE K_ZUSZUA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUSPT nchar(1) NULL,
	I_1 char(1) NULL /*Zgoszenie do ubezpiecze spoecznych i do ubezpie*/,
	I_2 nvarchar(1) NULL /*Zgoszenie zmiany / korekty danych osoby ubezpiecz*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(11) NULL /*PESEL*/,
	III_2 nvarchar(10) NULL /*NIP*/,
	III_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_5 nvarchar(31) NULL /*Nazwisko*/,
	III_6 nvarchar(22) NULL /*Imi pierwsze*/,
	III_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_1 nvarchar(22) NULL /*Imi drugie*/,
	IV_2 nvarchar(31) NULL /*Nazwisko rodowe*/,
	IV_3 nvarchar(22) NULL /*Obywatelstwo*/,
	IV_4 nvarchar(1) NULL /*Pe*/,
	V_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	V_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	V_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	VI_1 datetime NULL /*Data powstania obowizku ubezpieczenia (dd-mm-rrrr*/,
	VI_2 char(1) NULL /*Osoba zgaszana podlega ubezpieczeniom Emerytalnem*/,
	VI_3 char(1) NULL /*Osoba zgaszana podlega ubezpieczeniom Rentowym*/,
	VI_4 char(1) NULL /*Osoba zgaszana podlega ubezpieczeniom Chorobowemu*/,
	VI_5 char(1) NULL /*Osoba zgaszana podlega ubezpieczeniom Wypadkowemu*/,
	VII_1 datetime NULL /*Data powstania obowizku ubezpieczenia (dd-mm-rrrr*/,
	VII_2 nvarchar(3) NULL /*Kod oddziau NFZ*/,
	VIII_1 char(1) NULL /*Wnosz o objcie ubezpieczeniami: Emerytalnym*/,
	VIII_2 datetime NULL /*Od dnia (dd-mm-rrrr)*/,
	VIII_3 char(1) NULL /*Wnosz o objcie ubezpieczeniami: Rentowymi*/,
	VIII_4 datetime NULL /*Od dnia (dd-mm-rrrr)*/,
	VIII_5 char(1) NULL /*Wnosz o objcie ubezpieczeniami: Chorobowym*/,
	VIII_6 datetime NULL /*Od dnia (dd-mm-rrrr)*/,
	IX_1 datetime NULL /*Data powstania obowizku ubezpieczenia (dd-mm-rrrr*/,
	IX_2 nvarchar(3) NULL /*Kod oddziau NFZ*/,
	X_1 nvarchar(7) NULL /*Kod wykonywanego zawodu*/,
	X_2 nvarchar(9) NULL /*Kod pracy w szczeglnych warunkach / w szczeglnym*/,
	X_3_1 datetime NULL /*Okres pracy w szczeglnych warunkach / w szczegln*/,
	X_3_2 datetime NULL /*Okres pracy w szczeglnych warunkach / w szczegln*/,
	XI_1 nvarchar(5) NULL /*Kod pocztowy*/,
	XI_2 nvarchar(26) NULL /*Miejscowo*/,
	XI_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	XI_4 nvarchar(30) NULL /*Ulica*/,
	XI_5 nvarchar(7) NULL /*Numer domu*/,
	XI_6 nvarchar(7) NULL /*Numer lokalu*/,
	XI_7 nvarchar(12) NULL /*Numer telefonu*/,
	XI_8 nvarchar(12) NULL /*Symbol pastwa*/,
	XII_1 nvarchar(5) NULL /*Kod pocztowy*/,
	XII_2 nvarchar(26) NULL /*Miejscowo*/,
	XII_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	XII_4 nvarchar(30) NULL /*Ulica*/,
	XII_5 nvarchar(7) NULL /*Numer domu*/,
	XII_6 nvarchar(7) NULL /*Numer lokalu*/,
	XII_7 nvarchar(12) NULL /*Numer telefonu*/,
	XII_8 nvarchar(12) NULL /*Symbol pastwa*/,
	XIII_1 nvarchar(5) NULL /*Kod pocztowy*/,
	XIII_2 nvarchar(26) NULL /*Miejscowo*/,
	XIII_3 nvarchar(30) NULL /*Ulica*/,
	XIII_4 nvarchar(7) NULL /*Numer domu*/,
	XIII_5 nvarchar(7) NULL /*Numer lokalu*/,
	XIII_6 nvarchar(5) NULL /*Skrytka pocztowa*/,
	XIII_7 nvarchar(12) NULL /*Numer telefonu*/,
	XIII_8 nvarchar(12) NULL /*Symbol pastwa*/,
	XIII_9 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	XIV_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT
-- CONSTRAINT PK_K_ZUSZUA PRIMARY KEY 
-- (
	-- GUIDDOKUMENT ASC
-- )
)
;

CREATE TABLE K_ZUSZZA(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUSPT nchar(1) NULL,
	I_1 char(1) NULL /*Zgoszenie do ubezpieczenia zdrowotnego*/,
	I_2 nvarchar(1) NULL /*Zgoszenie zmiany / korekty danych osoby ubezpiecz*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(11) NULL /*PESEL*/,
	III_2 nvarchar(10) NULL /*NIP*/,
	III_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_5 nvarchar(31) NULL /*Nazwisko*/,
	III_6 nvarchar(22) NULL /*Imi pierwsze*/,
	III_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_1 nvarchar(22) NULL /*Imi drugie*/,
	IV_2 nvarchar(31) NULL /*Nazwisko rodowe*/,
	IV_3 nvarchar(22) NULL /*Obywatelstwo*/,
	IV_4 nvarchar(1) NULL /*Pe*/,
	V_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	V_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	V_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	VI_1 datetime NULL /*Data powstania obowizku ubezpieczenia (dd-mm-rrrr*/,
	VI_2 nvarchar(3) NULL /*Kod oddziau NFZ*/,
	VII_1 datetime NULL /*Data powstania obowizku ubezpieczenia (dd-mm-rrrr*/,
	VII_2 nvarchar(3) NULL /*Kod oddziau NFZ*/,
	VIII_1 nvarchar(5) NULL /*Kod pocztowy*/,
	VIII_2 nvarchar(26) NULL /*Miejscowo*/,
	VIII_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	VIII_4 nvarchar(30) NULL /*Ulica*/,
	VIII_5 nvarchar(7) NULL /*Numer domu*/,
	VIII_6 nvarchar(7) NULL /*Numer lokalu*/,
	VIII_7 nvarchar(12) NULL /*Numer telefonu*/,
	VIII_8 nvarchar(12) NULL /*Symbol pastwa*/,
	IX_1 nvarchar(5) NULL /*Kod pocztowy*/,
	IX_2 nvarchar(26) NULL /*Miejscowo*/,
	IX_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	IX_4 nvarchar(30) NULL /*Ulica*/,
	IX_5 nvarchar(7) NULL /*Numer domu*/,
	IX_6 nvarchar(7) NULL /*Numer lokalu*/,
	IX_7 nvarchar(12) NULL /*Numer telefonu*/,
	IX_8 nvarchar(12) NULL /*Symbol pastwa*/,
	X_1 nvarchar(5) NULL /*Kod pocztowy*/,
	X_2 nvarchar(26) NULL /*Miejscowo*/,
	X_3 nvarchar(30) NULL /*Ulica*/,
	X_4 nvarchar(7) NULL /*Numer domu*/,
	X_5 nvarchar(7) NULL /*Numer lokalu*/,
	X_6 nvarchar(5) NULL /*Skrytka pocztowa*/,
	X_7 nvarchar(12) NULL /*Numer telefonu*/,
	X_8 nvarchar(12) NULL /*Symbol pastwa*/,
	X_9 nvarchar(30) NULL /*Adres poczty elektronicznej*/,
	XI_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT
-- CONSTRAINT PK_K_ZUSZZA PRIMARY KEY 
-- (
	-- GUIDDOKUMENT ASC
-- )
)
;

CREATE TABLE K_ZUSZCNA_IV(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL,
	ID_BLOKU int NOT NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUSPT nchar(1) NULL,
	IV_A_1 nvarchar(1) NULL /*Zgoszenie nowego czonka rodziny / wyrejestrowani*/,
	IV_A_2 datetime NULL /*Data uzyskania / utraty uprawnie do ubezpieczenia*/,
	IV_A_3 nvarchar(11) NULL /*PESEL*/,
	IV_A_4 nvarchar(10) NULL /*NIP*/,
	IV_A_5 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	IV_A_6 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	IV_A_7 nvarchar(31) NULL /*Nazwisko*/,
	IV_A_8 nvarchar(22) NULL /*Imi pierwsze*/,
	IV_A_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_A_10 nvarchar(2) NULL /*Kod stopnia pokrewiestwa / powinowactwa*/,
	IV_A_11 char(1) NULL /*Czy pozostaje we wsplnym gospodarstwie domowym z */,
	IV_A_12 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	IV_B_1 nvarchar(5) NULL /*Kod pocztowy*/,
	IV_B_2 nvarchar(26) NULL /*Miejscowo*/,
	IV_B_3 nvarchar(26) NULL /*Gmina / Dzielnica*/,
	IV_B_4 nvarchar(30) NULL /*Ulica*/,
	IV_B_5 nvarchar(7) NULL /*Numer domu*/,
	IV_B_6 nvarchar(7) NULL /*Numer lokalu*/,
	IV_B_7 nvarchar(12) NULL /*Numer telefonu*/,
	IV_B_8 nvarchar(12) NULL /*Symbol pastwa*/,
	KOREKTA TEXT
-- CONSTRAINT PK_K_ZUSZCNA_IV PRIMARY KEY 
-- (
	-- GUIDDOKUMENT ASC,
	-- ID_BLOKU ASC
-- )
)
;

CREATE TABLE K_ZAMOWIENIE
(
	--ID uniqueidentifier,/*		Identyfikator pozycji zamwienia			// */
	TYP int NOT NULL,/*Typ pozycji zamwienia					// 1  dokument, 2  komplet dokumentw rozliczeniowych*/
	ID_PL_ZUS bigint NOT NULL,/*Identyfikator patnika po identyfikacji 			// */
	ID_UB_ZUS bigint,/*Identyfikator ubezpieczonego po identyfikacji		// */
	TYP_DOK char (7),/*Typ dokumentu pobieranego z kolejki			// */
	OKRES char(10),/*Okres rozliczeniowy (interpretowane s MM i RRRR) 	// */
	STATUSPT char(1)/*Status przetwarzania poszukiwanego dokumentu 	// N - wprowadzony*/
);

		
		



CREATE TABLE ZDK
(
	TYP int NOT NULL,/*Typ pozycji zamwienia					// 1  dokument, 2  komplet dokumentw rozliczeniowych, 11 - zamowienie dla ubezpieczonego*/
	ID_PL_ZUS bigint NOT NULL,/*Identyfikator patnika po identyfikacji 			// */
	ID_UB_ZUS bigint,/*Identyfikator ubezpieczonego po identyfikacji		// */
	TYP_DOK char (7),/*Typ dokumentu pobieranego z kolejki			// */
	OKRES char(10),/*Okres rozliczeniowy	// */
	STATUSPT char(1),/*Status przetwarzania poszukiwanego dokumentu 	// N - wprowadzony*/
	CECHY char(1),/*P	Pierwszorazowy	S	Pierwszorazowy, Sam za siebie	K	Korekta	L	Korekta, Sam za siebie	N	Nie dotyczy / Niezalenie od cech*/
	ZAKRES_WER	char(1),/*D	Dokument lub Blok	Z	Zestaw	G	Dokument gwny (bez blokw)	N	Niezalenie od zakresu*/
	KL datetime,
	KL_POPRZENI datetime,
	PLATNIK_ZUS char(1),
	PLATN_ADRES char(1),
	PLATN_DANEROZL char(1),
	PLATN_IDENT char(1),
	PLATN_IWA char(1),
	PLATN_OBOWIWA char(1),
	PLATN_OBOWOPLSKL char(1),
	PLATN_RACHBANK char(1),
	PLATN_RACHBANK_NRS char(1),
	PLATN_STATUS char(1),
	PLATN_ZSWA char(1),
	UBEZPIECZONY_ZUS char(1),
	UBEZP_30KROTNOSC char(1),
	UBEZP_ADRES char(1),
	UBEZP_CZLONEK_RODZINY char(1),
	UBEZP_IDENT char(1),
	UBEZP_INDSCHEMAT char(1),
	UBEZP_INNE char(1),
	UBEZP_KOD_PRACY char(1),
	UBEZP_PODLEGANIE char(1),
	WSZYSCY_UBEZPIECZENI char(1),
	PLATN_OSWRIA char(1),
	PLATN_MDG char(1),
	PLATN_DRA2RCA2 char(1),
	KL_12 char(1)
);


CREATE TABLE ZADR_ADRES
(
	GUIDDOKUMENT uniqueidentifier,
	NAZWADOKUMENTU text,
	ID_DOKUMENTU int,
	ID_BLOKU int,
	BLOK int,
	POLE int,
	MIEJSCOWOSC text,
	GMINA text,
	ULICA text,
	NRDOMU text,
	KODPOCZTOWY text,
	SYMBOLPANSTWA text,
	SKRYTKA text,
	USLUGA_RC text,
	USLUGA_OPISWER text,
	ADRES_POPRAWNY text
);

CREATE TABLE TMP_TAB(
               ID integer PRIMARY KEY AUTOINCREMENT NOT NULL, 
               ID_PLATNIK INTEGER,   
               ID_1 INTEGER,     
               BLOK_1 INTEGER,    
               TYP_1 INTEGER,  
               ID_2 INTEGER,    
               BLOK_2 INTEGER,  
               TYP_2 INTEGER,   
               ID_UBEZPIECZONY INTEGER,    
               IDRAPS VARCHAR(2),  
               IDOKRROL VARCHAR(6),
               KODTYTUB VARCHAR(6),  
               PRDOEM CHAR(1), 
               STNIEP CHAR(1),  
               PODWYMER NUMERIC(18,2), 
               PODWYMCH NUMERIC(18,2),  
               PODWYMWY NUMERIC(18,2),  
               PODWYMZDR NUMERIC(18,2), 
               LICZBA INTEGER,       
               NUMER INTEGER,     
               NAZWISKO VARCHAR(31),   
               IMIE VARCHAR(22),  
               PLATNIK_PRZEKAZ VARCHAR(55),   
               TYPID CHAR(1),      
               IDENTYFIK VARCHAR(11),  
               DATA1 DATETIME,   
               DATA2 DATETIME,    
               ID_PROGRAM INTEGER)  ;
			   
			   
CREATE TABLE PLATN_RACHBANK_NRS(
	ID INTEGER IDENTITY(1,1) NOT NULL,
	ID_PLATNIK INTEGER NOT NULL,
	NR_RACH_BANK varchar(36) NULL,
	DATAOD datetime NULL,
	STATUS_DANE char(1) NULL,
	INSERTTMP INTEGER NULL,
	ID_PL_ZUS INTEGER NULL,
	ROLA char NULL,
	ZAKRES INTEGER,
 CONSTRAINT PLATNRACHBANKNRS_PK PRIMARY KEY (ID)
);

CREATE TABLE PLATN_SALDA (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL, 
   SALDO_WN	NUMERIC(15,2),
   DATA_OST_OBR DATETIME NULL,
   ZAKRES INTEGER,
   INSERTTMP INTEGER NULL,
CONSTRAINT PLATNSALDA_PK PRIMARY KEY (ID)
);
   

CREATE TABLE PLATN_KALK_ODS
(
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL, 
   ZAKRES INTEGER,
   DATA_BAZOWA_ODS DATETIME NULL,
   ODS_DZIEN_01 NUMERIC(10,2),
   ODS_DZIEN_02 NUMERIC(10,2),
   ODS_DZIEN_03 NUMERIC(10,2),
   ODS_DZIEN_04 NUMERIC(10,2),
   ODS_DZIEN_05 NUMERIC(10,2),
   ODS_DZIEN_06 NUMERIC(10,2),
   ODS_DZIEN_07 NUMERIC(10,2),
   ODS_DZIEN_08 NUMERIC(10,2),
   ODS_DZIEN_09 NUMERIC(10,2),
   ODS_DZIEN_10 NUMERIC(10,2),
   ODS_DZIEN_11 NUMERIC(10,2),
   ODS_DZIEN_12 NUMERIC(10,2),
   ODS_DZIEN_13 NUMERIC(10,2),
   ODS_DZIEN_14 NUMERIC(10,2),
   ODS_DZIEN_15 NUMERIC(10,2),
   ODS_DZIEN_16 NUMERIC(10,2),
   ODS_DZIEN_17 NUMERIC(10,2),
   ODS_DZIEN_18 NUMERIC(10,2),
   ODS_DZIEN_19 NUMERIC(10,2),
   ODS_DZIEN_20 NUMERIC(10,2),
   ODS_DZIEN_21 NUMERIC(10,2),
   ODS_DZIEN_22 NUMERIC(10,2),
   ODS_DZIEN_23 NUMERIC(10,2),
   ODS_DZIEN_24 NUMERIC(10,2),
   ODS_DZIEN_25 NUMERIC(10,2),
   ODS_DZIEN_26 NUMERIC(10,2),
   ODS_DZIEN_27 NUMERIC(10,2),
   ODS_DZIEN_28 NUMERIC(10,2),
   ODS_DZIEN_29 NUMERIC(10,2),
   ODS_DZIEN_30 NUMERIC(10,2),
   ODS_DZIEN_31 NUMERIC(10,2),
   ODS_DZIEN_32 NUMERIC(10,2),
   ODS_DZIEN_33 NUMERIC(10,2),
   ODS_DZIEN_34 NUMERIC(10,2),
   ODS_DZIEN_35 NUMERIC(10,2),
   ODS_DZIEN_36 NUMERIC(10,2),
   ODS_DZIEN_37 NUMERIC(10,2),
   ODS_DZIEN_38 NUMERIC(10,2),
   ODS_DZIEN_39 NUMERIC(10,2),
   ODS_DZIEN_40 NUMERIC(10,2),
   ODS_DZIEN_41 NUMERIC(10,2),
   ODS_DZIEN_42 NUMERIC(10,2),
   ODS_DZIEN_43 NUMERIC(10,2),
   ODS_DZIEN_44 NUMERIC(10,2),
   ODS_DZIEN_45 NUMERIC(10,2),
   ODS_DZIEN_46 NUMERIC(10,2),
   ODS_DZIEN_47 NUMERIC(10,2),
   ODS_DZIEN_48 NUMERIC(10,2),
   ODS_DZIEN_49 NUMERIC(10,2),
   ODS_DZIEN_50 NUMERIC(10,2),
   ODS_DZIEN_51 NUMERIC(10,2),
   ODS_DZIEN_52 NUMERIC(10,2),
   ODS_DZIEN_53 NUMERIC(10,2),
   ODS_DZIEN_54 NUMERIC(10,2),
   ODS_DZIEN_55 NUMERIC(10,2),
   ODS_DZIEN_56 NUMERIC(10,2),
   ODS_DZIEN_57 NUMERIC(10,2),
   ODS_DZIEN_58 NUMERIC(10,2),
   ODS_DZIEN_59 NUMERIC(10,2),
   ODS_DZIEN_60 NUMERIC(10,2),
   ODS_DZIEN_61 NUMERIC(10,2),
   ODS_DZIEN_62 NUMERIC(10,2),
CONSTRAINT PLATNKALKODS_PK PRIMARY KEY (ID)
);



CREATE TABLE ZUSRPA_III(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_BLOKU int NOT NULL,
	ID_UB_ZUS bigint NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,	 
	III_A_1 NVARCHAR(31),
	III_A_2 NVARCHAR(22),
	III_A_3 NVARCHAR(1),
	III_A_4 NVARCHAR(11),
	III_A_5_1 NVARCHAR(4),
	III_A_5_2 NVARCHAR(1),
	III_A_5_3 NVARCHAR(1),   
	III_B_1 INTEGER,
	III_B_2 DECIMAL(6,2),
	III_B_3 INTEGER,
	III_B_4 DECIMAL(6,2),
	III_B_5 INTEGER,
	III_B_6 DECIMAL(6,2),
	III_C_1 INTEGER,
	III_C_2 DECIMAL(6,2),
	III_C_3 INTEGER,
	III_C_4 DECIMAL(6,2),
	III_C_5 INTEGER,
	III_C_6 DECIMAL(6,2),
	III_D_1 DECIMAL(6,2),
	III_E_1 INTEGER,
	III_E_2 DECIMAL(6,2),
	III_E_3 INTEGER,
	III_E_4 DECIMAL(6,2),
	III_E_5 INTEGER,
	III_E_6 DECIMAL(6,2),
	III_F_1 DATETIME,
	III_F_2 DATETIME,
	III_F_3_1 INTEGER,
	III_F_3_2 INTEGER,
	III_F_4 DATETIME,
	III_F_5 DATETIME,
	III_F_6_1 INTEGER,
	III_F_6_2 INTEGER,
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRPA_III PRIMARY KEY 
(
	GUIDDOKUMENT ASC,
	ID_BLOKU ASC
)
)
;


CREATE TABLE ZUSDRA2(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1 smallint NULL /*Identyfikator */,
	I_2 smallint NULL /*Rok rrrr)*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	I_5 nvarchar(12) NULL /*Znak i numer decyzji pokontrolnej*/,	
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 DECIMAL(10,2),
	III_2 DECIMAL(10,2),
	III_3 DECIMAL(10,2),
	IV_1 DECIMAL(10,2),
	IV_2 DECIMAL(10,2),
	IV_3 DECIMAL(10,2),
	IV_4 DECIMAL(10,2),
	IV_5 DECIMAL(10,2),
	IV_6 DECIMAL(10,2),
	V_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSDRA2 PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
)
;




CREATE TABLE ZUSRCA2(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1 smallint NULL /*Identyfikator */,
	I_2 smallint NULL /*Rok rrrr)*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	I_5 nvarchar(12) NULL /*Znak i numer decyzji pokontrolnej*/,	
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 DECIMAL(10,2),
	III_2 DECIMAL(10,2),
	III_3 DECIMAL(10,2),
	IV_1 DECIMAL(10,2),
	IV_2 DECIMAL(10,2),
	IV_3 DECIMAL(10,2),
	IV_4 DECIMAL(10,2),
	IV_5 DECIMAL(10,2),
	IV_6 DECIMAL(10,2),
	V_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSRCA2 PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
);

CREATE TABLE PLATN_OSWRIA(
	ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
	ID_PL_ZUS bigint NULL,
	ID_PLATNIK integer NULL,
	STATUS_OSW nchar(1) NULL,
	DATA_WYPEL_ZGL_OSW datetime NULL,
	DATA_WYPEL_ODW_OSW datetime NULL,
	CZY_RIA_PLATNIK nchar(1) NULL,
	INSERTTMP integer NULL	
);


CREATE TABLE PLATN_DRA2RCA2(
	ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
	ID_PLATNIK INTEGER,
	ID_DOKUMENTU integer NULL,
	TYP_DOK char(3) NULL,
	I_ID_DEKLARACJI smallint NULL,
	I_ROK_PODST_SKL	smallint NULL,
	III_PRZYCHOD_DZIAL decimal(10,2) NULL,
	III_NAJN_PODSTAWA decimal(10,2) NULL,
III_DOCHOD decimal(10, 2) NULL,
IV_PRZYCHOD_KARTA decimal(10, 2) NULL,
IV_DOCHOD_KARTA decimal(10, 2) NULL,
IV_PRZYCHOD_RYCZALT decimal(10, 2) NULL,
IV_DOCHOD_RYCZALT decimal(10, 2) ,
IV_PRZYCHOD_OGOLNE decimal(10, 2) NULL,
IV_DOCHOD_OGOLNE decimal(10, 2) NULL,
	IV_DATA_WYPEL datetime null,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	NR_DZIAL_PLAT smallint NULL,
	KOLEJKA char(1) default '0',
	INSERTTMP integer NULL
);


CREATE TABLE UBEZP_RPA(
	ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
	ID_DOKUMENT integer NULL,
	ID_PLATNIK integer NULL,
	ID_UBEZPIECZONY integer NULL,
	ID_DOK_ZUS integer NULL,
	NR_PODDOKUMENTU integer NULL,
	ID_PL_ZUS integer NULL,
	ID_UB_U_PLAT integer NULL,
	ID_UB_ZUS integer NULL,
	ID_WEW_DRA integer NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_OKRES_RAPORTU datetime NULL,
	III_NAZWISKO nvarchar(50) NULL,
	III_IMIE_PIERWSZE nvarchar(50) NULL,
	III_RODZAJ_DOK nvarchar(1 ) NULL,
	III_IDENT_DOK nvarchar(50) NULL,
	III_KOD_UBEZP nvarchar(4) NULL,
	III_PRAWO_DO_EME nvarchar(1) NULL,
	III_KOD_STOPNIA_NIEP nvarchar(1) NULL,
	III_PRZY_ROK_E_1  integer,
	III_PRZY_KWOTA_E_1 decimal(15,2),
	III_PRZY_ROK_E_2 integer,
	III_PRZY_KWOTA_E_2 decimal(15,2),
	III_PRZY_ROK_E_3 integer,
	III_PRZY_KWOTA_E_3 decimal(15,2),
	III_PRZY_ROK_W_1 integer,
	III_PRZY_KWOTA_W_1 decimal(15,2),
	III_PRZY_ROK_W_2 integer,
	III_PRZY_KWOTA_W_2 decimal(15,2),
	III_PRZY_ROK_W_3 integer,
	III_PRZY_KWOTA_W_3 decimal(15,2),
	III_PRZY_KWOTA_N_B decimal(15,2),
	III_PRZY_ROK_N_1 integer,
	III_PRZY_KWOTA_N_1 decimal(15,2),
	III_PRZY_ROK_N_2 integer,
	III_PRZY_KWOTA_N_2 decimal(15,2),
	III_PRZY_ROK_N_3 integer,
	III_PRZY_KWOTA_N_3 decimal(15,2),
	III_NAU_OKRES_OD_1 datetime,
	III_NAU_OKRES_DO_1 datetime,
	III_NAU_LICZ_W_C_1 varchar(3),
	III_NAU_MIAN_W_C_1 varchar(3),
	III_NAU_OKRES_OD_2 datetime,
	III_NAU_OKRES_DO_2 datetime,
	III_NAU_LICZ_W_C_2 varchar(3),
	III_NAU_MIAN_W_C_2 varchar(3),
	INSERTTMP integer NULL,
	TKL varchar(20),
    TKL1 varchar(20),
	KOLEJKA char(1) default '0'
	

);



CREATE TABLE PLATN_MDG(
	ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
	ID_PLATNIK INTEGER,
	ID_PL_ZUS INTEGER,
	ID_UB_ZUS INTEGER,
	LICZBA_DNI_DZIAL INTEGER,
	DATA_CZAS_REJ datetime,
	ROK_DNI_DZIAL INTEGER,	
	INSERTTMP integer NULL
);

CREATE TABLE K_DOKZR_ZUSOSW (
	ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
	ID_DOKUMENTU INTEGER,
	II_ZLOZENIEOSWIAD CHAR(1),
	II_ODWOLANIEOSWIAD CHAR(1), 
	III_DATAWYPELN DATETIME,
	ID_PL_ZUS INTEGER,
	INSERTTMP integer NULL
);

CREATE TABLE K_DOKZR_ZUSRIA(
	ID integer PRIMARY KEY AUTOINCREMENT NOT NULL,
	ID_DOKUMENTU INTEGER,
	IV_DATAROZWYG DATETIME,
	IV_KODROZWYG CHAR(3),
	IV_KODPODPRAWROZWY CHAR(3),
	IV_PODPRAWROZWYG NVARCHAR(180),
	IV_STRONAROZWYG CHAR(1),
	ID_PL_ZUS INTEGER,
	ID_UB_ZUS INTEGER,
	XII_DATAWYPELN DATETIME
);


CREATE TABLE ZUSDRA_43(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1 nvarchar(1) NULL /*Termin przysyania deklaracji i raportw DRA*/,
	I_2_1 int NULL /*Identyfikator deklaracji (numer)*/,
	I_2_2 date NULL /*Okres rozliczeniowy deklaracji (mm/rrrr)*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	I_5 nvarchar(12) NULL /*Znak i numer decyzji pokontrolnej*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 int NULL /*Liczba ubezpieczonych*/,
	III_2 nvarchar(1) NULL /*Wniosek pracodawcy o dofinansowanie skadek za oso*/,
	III_3 decimal(4,2) NULL /*Stopa procentowa skadek na ubezpieczenie wypadkow*/,
	IV_1 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sumy skadek*/,
	IV_2 decimal(11,2) NULL /*Skadki na ubezp. rent. Sumy skadek*/,
	IV_3 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sumy skadek*/,
	IV_4 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sk. finansowane przez: */,
	IV_5 decimal(11,2) NULL /*Skadki na ubezp. rent. Sk. finansowane przez: ub*/,
	IV_6 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sk. finansowane prz*/,
	IV_7 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sk. finansowane przez: */,
	IV_8 decimal(11,2) NULL /*Skadki na ubezp. rent. Sk. finansowane przez: p*/,
	IV_9 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sk. finansowane prz*/,
	IV_10 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sk. finansowane przez: */,
	IV_11 decimal(11,2) NULL /*Skadki na ubezp. rent. Sk. finansowane przez: bu*/,
	IV_12 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sk. finansowane prz*/,
	IV_13 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sk. finansowane przez: */,
	IV_14 decimal(11,2) NULL /*Skadki na ubezp. rent. Sk. finansowane przez: PF*/,
	IV_15 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sk. finansowane prz*/,
	IV_16 decimal(11,2) NULL /*Skadki na ubezp. emeryt. Sk. finansowane przez: */,
	IV_17 decimal(11,2) NULL /*Skadki na ubezp. rent. Sk. finansowane przez: Fu*/,
	IV_18 decimal(11,2) NULL /*Suma kw. na ub. emer. i rent. Sk. finansowane prz*/,
	IV_19 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sumy skadek*/,
	IV_20 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sumy skadek*/,
	IV_21 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp.*/,
	IV_22 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sk. finansowane przez: */,
	IV_23 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sk. finansowane przez: */,
	IV_24 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp. Sk. finansowane pr*/,
	IV_25 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sk. finansowane przez: */,
	IV_26 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sk. finansowane przez: */,
	IV_27 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp. Sk. finansowane pr*/,
	IV_28 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sk. finansowane przez: */,
	IV_29 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sk. finansowane przez: */,
	IV_30 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp. Sk. finansowane pr*/,
	IV_31 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sk. finansowane przez: */,
	IV_32 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sk. finansowane przez: */,
	IV_33 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp. Sk. finansowane pr*/,
	IV_34 decimal(11,2) NULL /*Skadki na ubezp. chorob. Sk. finansowane przez: */,
	IV_35 decimal(11,2) NULL /*Skadki na ubezp. wypadk. Sk. finansowane przez: */,
	IV_36 decimal(11,2) NULL /*Suma kw. na ub. chorob. i wyp. Sk. finansowane pr*/,
	IV_37 decimal(12,2) NULL /*Kwota skadek na ubezpieczenia spoeczne, ktre po*/,
	V_1 decimal(11,2) NULL /*Kwota wypaconych wiadcze z ubezpieczenia chorob*/,
	V_2 decimal(11,2) NULL /*Kwota wynagrodzenia nalenego patnikowi od wypac*/,
	V_3 decimal(11,2) NULL /*Kwota wypaconych wiadcze z ubezpieczenia wypadk*/,
	V_4 decimal(11,2) NULL /*Kwota wypaconych wiadcze finansowanych z budet*/,
	V_5 decimal(12,2) NULL /*aczna kwota do potrcenia (p.01 + p.02 + p.03 + p*/,
	VI_1 decimal(12,2) NULL /*Kwota do zwrotu przez ZUS*/,
	VI_2 decimal(12,2) NULL /*Kwota do zapaty przez patnika*/,
	VII_1 decimal(11,2) NULL /*Kwota nalenych skadek finansowana przez patnika*/,
	VII_2 decimal(11,2) NULL /*Kwota nalenych skadek finansowana przez ubezpiec*/,
	VII_3 decimal(11,2) NULL /*Kwota nalenych skadek finansowana przez Fundusz */,
	VII_4 decimal(11,2) NULL /*Kwota nalenych skadek finansowanych z budetu pa*/,
	VII_5 decimal(11,2) NULL /*Kwota nalenych skadek do przekazania przez patn*/,
	VII_6 decimal(10,2) NULL /*Kwota nalenego wynagrodzenia dla patnika*/,
	VII_7 decimal(12,2) NULL /*Kwota do zapaty (p.01 - p.04)*/,
	VIII_1 decimal(11,2) NULL /*Kwota nalenych skadek na Fundusz Pracy*/,
	VIII_2 decimal(11,2) NULL /*Kwota nalenych skadek na Fundusz Gwarantowanych */,
	VIII_3 decimal(12,2) NULL /*Kwota do zapaty (p.01 + p.02)*/,
	IX_1 int NULL /*Liczba pracownikw, za ktrych jest opacana skad*/,
	IX_2 int NULL /*Liczba stanowisk pracy w szczeglnych warunkach lu*/,
	IX_3 decimal(12,2) NULL /*Suma nalenych skadek na Fundusz Emerytur Pomosto*/,
	X_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	X_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	X_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	X_2 decimal(10,2) NULL /*Podstawa wymiaru skadek na ubezpieczenia emerytal*/,
	X_3 decimal(10,2) NULL /*Podstawa wymiaru skadek na ubezpieczenie chorobow*/,
	X_4 decimal(10,2) NULL /*Podstawa wymiaru skadek na ubezpieczenie wypadkow*/,
	X_5 decimal(10,2) NULL /*Podstawa wymiaru skadek na ubezpieczenie zdrowotn*/,
	X_6 nvarchar(1) NULL /*Informacja o przekroczeniu rocznej podstawy wymiar*/,
	XI_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSDRA_43 PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
);

CREATE TABLE ZUSZWUA_43(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_1 smallint NULL /*Wyrejestrowanie z ubezpiecze spoecznych i ubezpi*/,
	I_2 smallint NULL /*Zgoszenie korekty danych o wyrejestrowaniu z ubez*/,
	I_3 datetime NULL /*Data nadania*/,
	I_4 nvarchar(20) NULL /*Nalepka R*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 nvarchar(11) NULL /*PESEL*/,
	III_2 nvarchar(10) NULL /*NIP*/,
	III_3 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	III_4 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	III_5 nvarchar(31) NULL /*Nazwisko*/,
	III_6 nvarchar(22) NULL /*Imi pierwsze*/,
	III_7 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	IV_1_1 nvarchar(4) NULL /*Kod tytuu ubezpieczenia*/,
	IV_1_2 nvarchar(1) NULL /*Kod prawa do emerytury i renty*/,
	IV_1_3 nvarchar(1) NULL /*Kod stopnia niepenosprawnoci*/,
	IV_2 datetime NULL /*Od dnia (dd-mm-rrrr)*/,
	IV_3 nvarchar(3) NULL /*Kod przyczyny wyrejestrowania*/,
	V_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	KOREKTA TEXT,
CONSTRAINT PK_ZUSZWUA_43 PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
);


CREATE TABLE ZUSDRA2_50(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1 smallint NULL /*Identyfikator */,
	I_2 smallint NULL /*Rok rrrr)*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 DECIMAL(8,2),
	III_2 DECIMAL(8,2),
	IV_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSDRA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
);


CREATE TABLE ZUSRCA2_50(
	GUIDDOKUMENT uniqueidentifier NOT NULL,
	ID_DOKUMENTU bigint NULL, 
	KOLEJNOSC unsigned bigint NULL,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	ID_PL_ZUS_STATUS nchar(1) NULL,
	ID_UB_ZUS_STATUS nchar(1) NULL,
	STATUS_WERYFIKACJI nchar(1) NULL,
	STATUS_KONTROLI nchar(1) NULL,
	STATUS_WYLICZENIA nchar(1) NULL,
	PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
	I_1 smallint NULL /*Identyfikator */,
	I_2 smallint NULL /*Rok rrrr)*/,
	II_1 nvarchar(10) NULL /*NIP*/,
	II_2 nvarchar(14) NULL /*REGON*/,
	II_3 nvarchar(11) NULL /*PESEL*/,
	II_4 nvarchar(1) NULL /*Rodzaj dokumentu*/,
	II_5 nvarchar(9) NULL /*Seria i nr dokumentu*/,
	II_6 nvarchar(31) NULL /*Nazwa skrcona*/,
	II_7 nvarchar(31) NULL /*Nazwisko*/,
	II_8 nvarchar(22) NULL /*Imi pierwsze*/,
	II_9 datetime NULL /*Data urodzenia (dd-mm-rrrr)*/,
	III_1 DECIMAL(8,2),
	III_2 DECIMAL(8,2),
	IV_1 datetime NULL /*Data wypenienia (dd-mm-rrrr)*/,
	TKL varchar(20),
	KOREKTA TEXT,
	NUMER_SCHEMATU INT,
CONSTRAINT PK_ZUSDRA PRIMARY KEY 
(
	GUIDDOKUMENT ASC
)
);



CREATE INDEX IX1_ZUSZZA ON ZUSZZA ( ID_UB_ZUS ASC );
CREATE INDEX IX1_ZUSZWUA ON ZUSZWUA ( ID_UB_ZUS ASC );
CREATE INDEX IX1_ZUSZUA ON ZUSZUA ( ID_UB_ZUS ASC );
CREATE INDEX IX1_ZUSZIUA ON ZUSZIUA ( ID_UB_ZUS ASC );
CREATE INDEX IX1_ZUSZCNA ON ZUSZCNA ( ID_UB_ZUS ASC );
CREATE INDEX IX1_ZUSDRA ON ZUSDRA ( ID_UB_ZUS ASC );
CREATE INDEX IX1_ZUSZSWA_III ON ZUSZSWA_III ( ID_UB_ZUS ASC );
CREATE INDEX IX1_UBEZPIECZONY_ZUS ON UBEZPIECZONY_ZUS ( ID_UB_ZUS ASC );
CREATE INDEX IX1_UBEZP_ADRES ON UBEZP_ADRES ( ID_UB_ZUS ASC );
CREATE INDEX IX1_UBEZP_IDENT ON UBEZP_IDENT ( ID_UB_ZUS ASC );
CREATE INDEX IX1_UBEZP_KOD_PRACY ON UBEZP_KOD_PRACY ( ID_UB_ZUS ASC );
CREATE INDEX IX1_UBEZP_INNE ON UBEZP_INNE ( ID_UB_ZUS ASC );
CREATE INDEX IX1_UBEZP_CZLONEK_RODZINY ON UBEZP_CZLONEK_RODZINY ( ID_UB_ZUS ASC );
CREATE INDEX IX1_UBEZP_30KROTNOSC ON UBEZP_30KROTNOSC ( ID_UB_ZUS ASC );
CREATE INDEX IX1_UBEZP_PODLEGANIE ON UBEZP_PODLEGANIE ( ID_UB_ZUS ASC );
CREATE INDEX IX1_UBEZP_SKLAD ON UBEZP_SKLAD ( ID_UB_ZUS ASC );
CREATE INDEX IX1_UBEZP_SWIAD ON UBEZP_SWIAD ( ID_UB_ZUS ASC );
CREATE INDEX IX1_ZUSAKU ON ZUSAKU ( ID_UB_ZUS ASC );
CREATE INDEX IX1_K_ZUSZCNA ON K_ZUSZCNA ( ID_UB_ZUS ASC );
CREATE INDEX IX1_K_ZUSZWUA ON K_ZUSZWUA ( ID_UB_ZUS ASC );
CREATE INDEX IX1_K_ZUSZUA ON K_ZUSZUA ( ID_UB_ZUS ASC );
CREATE INDEX IX1_K_ZUSZZA ON K_ZUSZZA ( ID_UB_ZUS ASC );
CREATE INDEX IX1_K_ZAMOWIENIE ON K_ZAMOWIENIE ( ID_UB_ZUS ASC );

CREATE  INDEX IX_ZUSRSA_III_III_A_4 ON ZUSRSA_III(III_A_4 ASC);

CREATE INDEX IX1_TMP_TAB_ID_UBEZPIECZONY ON TMP_TAB ( ID_UBEZPIECZONY ASC );
CREATE INDEX IX2_TMP_TAB_IDENTYFIK ON TMP_TAB ( IDENTYFIK ASC );

CREATE INDEX IX2_ZUSZIUA ON ZUSZIUA ( III_1 ASC );

CREATE INDEX IX3_BLAD ON BLAD (	GUIDKEDU ASC, GUIDDOKUMENT ASC, ID_DOKUMENTU ASC);


CREATE INDEX IX_UBEZP_SKLAD_ID_DOKUMENT ON UBEZP_SKLAD (ID_DOKUMENT ASC)
CREATE INDEX IX_UBEZP_SKLAD_ID_DOK_ZUS ON UBEZP_SKLAD (ID_DOK_ZUS ASC)
CREATE INDEX IX_UBEZP_SWIAD_ID_DOKUMENT ON UBEZP_SWIAD (ID_DOKUMENT ASC)
CREATE INDEX IX_UBEZP_SWIAD_ID_DOK_ZUS ON UBEZP_SWIAD (ID_DOK_ZUS ASC)
CREATE INDEX IX_DOKROZL_RAPORT_ID_DOKUMENT ON DOKROZL_RAPORT (ID_DOKUMENT ASC)
CREATE INDEX IX_DOKROZL_RAPORT_ID_DOK_ZUS ON DOKROZL_RAPORT (ID_DOK_ZUS ASC)

