
CREATE TABLE dbo.KODSWPRZ  (KODSWPRZ VARCHAR(3) NOT NULL)
GO

CREATE TABLE dbo.UBEZPIECZONY  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ATRYBUT_I INTEGER,
   ATRYBUT_II INTEGER,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   ID_UZYTKOWNIK INTEGER,
   DATA_UTW DATETIME,
   INSERTTMP INTEGER,
   ID_PL_ZUS INTEGER,
   ID_UB_ZUS INTEGER,
   STATUS_POTW_W_ZUS CHAR(1),
   ZNACZNIK_CZASU DATETIME,
   DATA_POTW_W_ZUS DATETIME,
   STATUS_WER_AUT CHAR(1),
   SKROT_DANYCH VARCHAR(40))
GO

CREATE TABLE dbo.DOKUMENT  (ID_DOKUMENT INTEGER IDENTITY (1, 1) NOT NULL,
   ID_DOK_NAD INTEGER,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER,
   TYP INTEGER NOT NULL,
   ATRYBUT_I INTEGER,
   ATRYBUT_II INTEGER,
   NUMER INTEGER,
   IMIEPIERW VARCHAR(22),
   NAZWISKO VARCHAR(31),
   PESEL VARCHAR(11),
   NIP VARCHAR(10),
   RODZDOK CHAR(1),
   SERIANRDOK VARCHAR(9),
   IDRAPS VARCHAR(2),
   OKRROZL VARCHAR(6),
   WERSJA_WER INTEGER,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   DATA DATETIME,
   INSERTTMP INTEGER,
   ID_TECH_DOK INTEGER,
   ID_IMPORT_DOK INTEGER,
   STATUSPTOLD CHAR(1),
   SERIA INTEGER,
   L_POZYCJI INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   KOREKTA_KOM TEXT,
   NR_BLOK INTEGER,
   STATUSWRZUS CHAR(1),
   ID_ODDZIAL INTEGER,
   TYP_BLOKU INTEGER)
GO

CREATE TABLE dbo.UBEZP_ADRES  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   ID_DOKUMENT INTEGER,
   TYP_ADRESU CHAR(1),
   KODPOCZTOWY VARCHAR(5),
   MIEJSCOWOSC VARCHAR(26),
   GMINA VARCHAR(26),
   ULICA VARCHAR(30),
   NUMERDOMU VARCHAR(7),
   NUMERLOKALU VARCHAR(7),
   SKRPOCZTOWA VARCHAR(5),
   TELEFON VARCHAR(12),
   FAKS VARCHAR(12),
   ADRPOCZTYEL VARCHAR(30),
   STATUS_DANE CHAR(1),
   DATAOD DATETIME,
   INSERTTMP INTEGER,
   ID_PL_ZUS INTEGER,
   ID_UB_ZUS INTEGER)
GO

CREATE TABLE dbo.BLAD_DOK  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_OBIEKT INTEGER NOT NULL,
   TYP INTEGER,
   ID_BLOK_BLW INTEGER,
   ID_MIEJSCE INTEGER,
   NUMER INTEGER NOT NULL,
   KLASA INTEGER,
   BLOK INTEGER,
   POLE INTEGER,
   SEGMENT INTEGER,
   INSERTTMP INTEGER,
   ID_OBIEKT2 INTEGER)
GO

CREATE TABLE dbo.TMP_TAB  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER,
   ID_1 INTEGER,
   BLOK_1 INTEGER,
   TYP_1 INTEGER,
   ID_2 INTEGER,
   BLOK_2 INTEGER,
   TYP_2 INTEGER,
   ID_UBEZPIECZONY INTEGER,
   IDRAPS VARCHAR(2),
   IDOKRROL VARCHAR(6),
   KODTYTUB VARCHAR(6),
   PRDOEM CHAR(1),
   STNIEP CHAR(1),
   PODWYMER NUMERIC(18,2),
   PODWYMCIW NUMERIC(18,2),
   PODWYMZDR NUMERIC(18,2),
   LICZBA INTEGER,
   NUMER INTEGER,
   NAZWISKO VARCHAR(31),
   IMIE VARCHAR(22),
   PLATNIK_PRZEKAZ VARCHAR(55),
   TYPID CHAR(1),
   IDENTYFIK VARCHAR(11),
   DATA1 DATETIME,
   DATA2 DATETIME,
   ID_PROGRAM INTEGER)
GO

CREATE TABLE dbo.ZUSZBA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_DATANADANIA DATETIME,
   I_2_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   IX_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   L_POZYCJI INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.BLOKADA  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PROGRAM INTEGER NOT NULL,
   ID_BLOKADA INTEGER NOT NULL,
   ID_UZYTKOWNIK INTEGER NOT NULL,
   KOMPUTER VARCHAR(64),
   TYP INTEGER NOT NULL,
   POZIOM INTEGER NOT NULL,
   ID_OBIEKT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   ID_ZESTAW INTEGER,
   CZAS DATETIME NOT NULL,
   KONTEKST INTEGER NOT NULL)
GO

CREATE TABLE dbo.ZUSZAA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_DATANADANIA DATETIME,
   I_2_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   IX_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   L_POZYCJI INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.ZESTAW  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_ZES_NAD INTEGER,
   ID_PLATNIK INTEGER NOT NULL,
   NUMER INTEGER,
   NAZWA VARCHAR(255),
   NAZWA_PLIKU_KSIMAIL TEXT,
   DATA_WYS DATETIME,
   DATA_POTW DATETIME,
   KANAL CHAR(1),
   POTWIERDZENIE TEXT,
   STATUSPT CHAR(1),
   STATUSWR CHAR(1),
   UWAGI TEXT,
   DATA_UTW_ZEST DATETIME,
   DATA_ID_POTW DATETIME,
   ID_POTW VARCHAR(35),
   SC_DO_POTW TEXT,
   SC_DO_OST TEXT,
   PLIK_POTW CHAR(1),
   POTW_JEDN_ZUS VARCHAR (10),
   DATA_NAD DATETIME,
   DATA_REJ DATETIME,
   STATUSPT_AT TEXT,
   ADRESHTTP VARCHAR (50),
   TRESC TEXT,
   PRZYG_OPIS TEXT,
   RODZAJ_BL TEXT,
   ID_PLIK INTEGER,
   HASH INTEGER,
   ID_AT VARCHAR(128),
   SKROT VARCHAR(128),
   ID_PRZESYLKA INTEGER,
   SPOSOB CHAR (1),	
   INSERTTMP INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   STATUSWRZUS CHAR(1))
GO

CREATE TABLE dbo.ZUSRZA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_1IDRAPS VARCHAR(2),
   I_1_2OKRROZL VARCHAR(6),
   I_2_NRKARTKI_RZA NUMERIC(4),
   I_3_SKWNASTR_1_8 NUMERIC(8,2),
   I_4_SKWNASTR_2_8 NUMERIC(8,2),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   XIII_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   ZN_KOR CHAR(1),
   SERIA INTEGER,
   L_POZYCJI INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.PLATN_DANEROZL  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   NAZWA VARCHAR(16),
   WARTOSC VARCHAR(8),
   DATAOD DATETIME,
   DATADO DATETIME,
   STATUS_DANE CHAR(1),
   INSERTTMP INTEGER,
   ID_PL_ZUS INTEGER, 
   ZAKRES_NUMEROW_DEKLARACJI SMALLINT,
   ZRODLO CHAR(1))
GO

CREATE TABLE dbo.PLATN_ADRES  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOKUMENT INTEGER,
   TYP_ADRESU CHAR(1),
   KODPOCZTOWY VARCHAR(5),
   MIEJSCOWOSC VARCHAR(26),
   GMINA VARCHAR(26),
   ULICA VARCHAR(30),
   NUMERDOMU VARCHAR(7),
   NUMERLOKALU VARCHAR(7),
   SKRPOCZTOWA VARCHAR(5),
   TELEFON VARCHAR(12),
   TELDOTELETR VARCHAR(12),
   FAKS VARCHAR(12),
   ADRPOCZTYEL VARCHAR(30),
   WOJEWODZTWO VARCHAR(26),
   STATUS_DANE CHAR(1),
   DATAOD DATETIME,
   INSERTTMP INTEGER,
   ID_PL_ZUS INTEGER) 
GO

CREATE TABLE dbo.ZUSZPA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_ZGLPLSKLADE CHAR(1),
   I_2_ZGLZMDAPLATNIK CHAR(1),
   I_3_DATANADANIA DATETIME,
   I_4_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_NAZWASKR VARCHAR(31),
   III_1_NAZWAFIRMA VARCHAR(62),
   III_2_PLJESTJEDBUD CHAR(1),
   III_3_PLJEDPOZABU CHAR(1),
   III_4_NORGANUZALOZ VARCHAR(31),
   III_5_PLPODLWPISEW CHAR(1),
   III_6_DATAWPREJEW DATETIME,
   III_7_NRWPISREJEW VARCHAR(15),
   III_8_NORGANUREJEW VARCHAR(72),
   III_9_DATAPOWOBUB DATETIME,
   III_10_DATARDZIAL DATETIME,
   IV_1_NRRACHUNKU VARCHAR(36),
   IV_2_CZYINNERACH CHAR(1),
   V_1_PLMASTPRCHR CHAR(1),
   V_2_DATAOTSTPCHR DATETIME,
   V_3_DATAUTRSTPRCH DATETIME,
   V_4_ADRDZIALNSIED CHAR(1),
   VI_1_KODPOCZTOWY VARCHAR(5),
   VI_2_MIEJSCOWOSC VARCHAR(26),
   VI_3_GMINA VARCHAR(26),
   VI_4_ULICA VARCHAR(30),
   VI_5_NUMERDOMU VARCHAR(7),
   VI_6_NUMERLOKALU VARCHAR(7),
   VI_7_TELEFON VARCHAR(12),
   VI_8_FAKS VARCHAR(12),
   VI_9_ADRPOCZTYEL VARCHAR(30),
   VII_1_KODPOCZTOWY VARCHAR(5),
   VII_2_MIEJSCOWOSC VARCHAR(26),
   VII_3_ULICA VARCHAR(30),
   VII_4_NUMERDOMU VARCHAR(7),
   VII_5_NUMERLOKALU VARCHAR(7),
   VII_6_TELDOTELETR VARCHAR(12),
   VII_7_SKRPOCZTOWA VARCHAR(5),
   VII_8_TELEFON VARCHAR(12),
   VII_9_FAKS VARCHAR(12),
   VII_10_ADRPOCZTYEL VARCHAR(30),
   VIII_1_NIP VARCHAR(10),
   VIII_2_REGON VARCHAR(14),
   VIII_3_NAZWASKR VARCHAR(31),
   IX_1_LZALZBA VARCHAR(3),
   IX_2_LZALZAA VARCHAR(3),
   IX_3_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.UBEZP_ZUSRZA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   III_A_1_NAZWISKO VARCHAR(31),
   III_A_2_IMIEPIERW VARCHAR(22),
   III_A_3_TYPID CHAR(1),
   III_A_4_IDENTYFIK VARCHAR(11),
   III_B_1_1KODTYTUB VARCHAR(4),
   III_B_1_2PRDOEM CHAR(1),
   III_B_1_3STNIEP CHAR(1),
   III_B_2_PODSTWYMSK NUMERIC(8,2),
   III_B_3_KWSKLADKI NUMERIC(7,2),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   STATUSWS INTEGER NOT NULL,
   INSERTTMP INTEGER,
   NRSCIEZWYL INTEGER,
   III_B_3_KWSKLZP_R NUMERIC(7,2),
   III_B_4_KWSKLZBP_R NUMERIC(7,2),
   III_B_5_KWSKLZU_R NUMERIC(7,2),
   III_B_6_KWSKLZFK_R NUMERIC(7,2),
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.ZUSZWUA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   I_1_WYRSPOIZDR CHAR(1),
   I_2_WYRSPOL CHAR(1),
   I_3_WYRUBZDR CHAR(1),
   I_4_ZGLKORDAWYRZUB CHAR(1),
   I_5_DATANADANIA DATETIME,
   I_6_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_PESEL VARCHAR(11),
   III_2_NIP VARCHAR(10),
   III_3_RODZDOK CHAR(1),
   III_4_SERIANRDOK VARCHAR(9),
   III_5_NAZWISKO VARCHAR(31),
   III_6_IMIEPIERW VARCHAR(22),
   III_7_DATAURODZ DATETIME,
   IV_1_1KODTYTUB VARCHAR(4),
   IV_1_2PRDOEM CHAR(1),
   IV_1_3STNIEP CHAR(1),
   IV_2_RODZAJUBEM CHAR(1),
   IV_3_ODDNIAUBEM DATETIME,
   IV_4_KODTYTWYRUB VARCHAR(3),
   IV_5_RODZAJUBR CHAR(1),
   IV_6_ODDNIAUBR DATETIME,
   IV_7_KODTYTWYRUB VARCHAR(3),
   IV_8_RODZAJUBCH CHAR(1),
   IV_9_ODDNIAUBCH DATETIME,
   IV_10_KODTYTWYRUB VARCHAR(3),
   IV_11_RODZAJUBWYP CHAR(1),
   IV_12_ODDNIAWYP DATETIME,
   IV_13_KODTYTWYRUB VARCHAR(3),
   IV_14_RODZAJUBZDR CHAR(1),
   IV_15_ODDNIAZUBZDR DATETIME,
   IV_16_KODTYTWYRUB VARCHAR(3),
   V_1_1KODTYTUB VARCHAR(4),
   V_1_2PRDOEM CHAR(1),
   V_1_3STNIEP CHAR(1),
   V_2_DATAKONTUBEMR DATETIME,
   /* ******** seria 7 ******* */
   V_1_DATAWYGAS DATETIME,
   V_2_KODWYGAS CHAR(3), 
   V_3_KODPODSTPRAW CHAR(3),
   V_4_PODSTPRAW VARCHAR(72),
   V_5_STRONAINI CHAR(1),
   /* ******************* */
   VI_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.BLK_ZBA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   III_1_KODRODZZGL CHAR(1),
   III_2_NRRACHUNKU VARCHAR(36),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   STATUS_KONTROLI CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.IMPORT  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UZYTKOWNIK INTEGER,
   STATUS VARCHAR(1),
   DATA_ROZP DATETIME,
   DATA_ZAK DATETIME,
   RODZAJ VARCHAR(5),
   LISTA_PLIKOW TEXT,
   LISTA_BLAD_STR TEXT,
   POMINIETE_FILTR INTEGER,
   POMINIETE_FILTR_BLW INTEGER,
   POMINIETE_DOK INTEGER,
   POMINIETE_DOK_BLW INTEGER,
   BEZ_ID_PLATNIKA INTEGER,
   BEZ_ID_UBEZP INTEGER,
   BEZ_ID_UBEZP_BLW INTEGER,
   BLEDY_KRYT INTEGER,
   BLEDY_KRYT_BLW INTEGER,
   DO_WYJASNIENIA INTEGER,
   DO_WYJASNIENIA_BLW INTEGER,
   LICZBA_ZAIMP INTEGER,
   LICZBA_ZAIMP_BLW INTEGER,
   NOWE INTEGER,
   NOWE_BLW INTEGER,
   NADPISANE INTEGER,
   NADPISANE_BLW INTEGER,
   SUMOWANE INTEGER,
   SUMOWANE_BLW INTEGER,
   UBEZP_NOWE INTEGER,
   UBEZP_ZMIENIONE INTEGER,
   ZAKRES_ZAS INTEGER,
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.ZUSRGA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_1IDRAPS VARCHAR(2),
   I_1_2OKRROZL VARCHAR(6),
   I_2_NRKARTKI_RGA NUMERIC(4),
   I_3_SKWNASTR_1_9 NUMERIC(9,2),
   I_4_SKWNASTR_2_9 NUMERIC(9,2),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   VII_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   ZN_KOR CHAR(1),
   SERIA INTEGER,
   L_POZYCJI INTEGER)
GO

CREATE TABLE dbo.UBEZP_IDENT  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   ID_UBEZPIECZONY_SCAL INTEGER,
   ID_SDWIUBEZPIECZONY INTEGER,
   ID_DOKUMENT INTEGER,
   ZRODLO_DANYCH VARCHAR (50),
   PESEL VARCHAR (11),
   NIP VARCHAR (10),
   RODZDOK CHAR (1),
   SERIANRDOK VARCHAR (9),
   NAZWISKO VARCHAR (31),
   IMIEPIERW VARCHAR (22),
   DATAURODZ DATETIME,
   STATUS_DANE CHAR (1),
   DATAOD DATETIME,
   TYP_BLOK CHAR (1),
   INSERTTMP INTEGER,
   ID_PL_ZUS INTEGER,
   ID_UB_ZUS INTEGER)
GO

CREATE TABLE dbo.BLK_ZAA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   III_1_KODRODZZGL2 CHAR(1),
   III_2_KODPOCZTOWY VARCHAR(5),
   III_3_MIEJSCOWOSC VARCHAR(26),
   III_4_GMINA VARCHAR(26),
   III_5_ULICA VARCHAR(30),
   III_6_NUMERDOMU VARCHAR(7),
   III_7_NUMERLOKALU VARCHAR(7),
   III_8_TELEFON VARCHAR(12),
   III_9_FAKS VARCHAR(12),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   STATUS_KONTROLI CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.CZR_ZUSZCNA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   IV_A_1_ZGLCZLWERA CHAR(1),
   IV_A_2_DATAUZUPRZD DATETIME,
   IV_A_3_PESEL VARCHAR(11),
   IV_A_4_NIP VARCHAR(10),
   IV_A_5_RODZDOK CHAR(1),
   IV_A_6_SERIANRDOK VARCHAR(9),
   IV_A_7_NAZWISKO VARCHAR(31),
   IV_A_8_IMIEPIERW VARCHAR(22),
   IV_A_9_DATAURODZ DATETIME,
   IV_A_10_KODSTPOKR VARCHAR(2),
   IV_A_11_NAUTRZOSUB CHAR(1),
   IV_A_12_POGOSPZUB CHAR(1),
   IV_A_13_STNIEP CHAR(1),
   IV_B_1_KODPOCZTOWY VARCHAR(5),
   IV_B_2_MIEJSCOWOSC VARCHAR(26),
   IV_B_3_GMINA VARCHAR(26),
   IV_B_4_ULICA VARCHAR(30),
   IV_B_5_NUMERDOMU VARCHAR(7),
   IV_B_6_NUMERLOKALU VARCHAR(7),
   IV_B_7_TELEFON VARCHAR(12),
   IV_B_8_FAKS VARCHAR(12),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   STATUS_KONTROLI CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.PARAMETRY  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   NAZWA VARCHAR(25),
   WARTOSC VARCHAR(255),
   DATAOD DATETIME,
   DATADO DATETIME)
GO

CREATE TABLE dbo.UBEZP_ZUSRGA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   III_A_1_NAZWISKO VARCHAR(31),
   III_A_2_IMIEPIERW VARCHAR(22),
   III_A_3_TYPID CHAR(1),
   III_A_4_IDENTYFIK VARCHAR(11),
   III_B_1_1KODTYTUB VARCHAR(4),
   III_B_1_2PRDOEM CHAR(1),
   III_B_1_3STNIEP CHAR(1),
   III_B_2_KODSWPRZER VARCHAR(3),
   III_B_3_OKROD_RSA VARCHAR(4),
   III_B_4_OKRDO_RSA VARCHAR(4),
   III_B_5_LDNIZASILK VARCHAR(2),
   III_B_6_KODCHOROBY VARCHAR(2),
   III_B_7_KWOTASW NUMERIC(7,2),
   III_C_1_KODOKRPGOR VARCHAR(2),
   III_C_2_OKRPRGOROD VARCHAR(4),
   III_C_3_OKRPRGORDO VARCHAR(4),
   III_C_4_KODDRRATOW CHAR(1),
   III_C_5_OKRDRRATOD VARCHAR(4),
   III_C_6_OKRDRRATDO VARCHAR(4),
   III_C_7_LDNIOBPR VARCHAR(2),
   III_C_8_DNIPRZEPR VARCHAR(2),
   III_C_9_LDNIZJAZD VARCHAR(2),
   III_C_10_KODDNIZJA CHAR(1),
   III_C_11_KODUNUSP CHAR(1),
   III_C_12_OKURNOBOD VARCHAR(4),
   III_C_13_OKRURLNDO VARCHAR(4),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   STATUSWS INTEGER NOT NULL,
   INSERTTMP INTEGER,
   ALGORYTM VARCHAR(3))
GO

CREATE TABLE dbo.PLATN_IDENT  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_ZGL INTEGER,
   NIP VARCHAR(10),
   REGON VARCHAR(14),
   PESEL VARCHAR(11),
   RODZDOK CHAR(1),
   SERIANRDOK VARCHAR(9),
   NAZWASKR VARCHAR(31),
   NAZWISKO VARCHAR(31),
   IMIEPIERW VARCHAR(22),
   DATAURODZ DATETIME,
   NAZWAFIRMA VARCHAR(62),
   TYP_PLATNIKA CHAR(1),
   STATUS_DANE CHAR(1),
   DATAOD DATETIME,
   TYP_BLOK CHAR(1),
   INSERTTMP INTEGER,
   ID_PL_ZUS INTEGER,
   ZRODLO_DANYCH VARCHAR(50)) 
GO

CREATE TABLE dbo.PLATNIK  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   NAZWASKR VARCHAR(31),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   IDBIURARACH INTEGER,
   DATAOD DATETIME,
   DATADO DATETIME,
   ID_DOK_ZGL INTEGER,
   ID_DOK_WYR INTEGER,
   ID_UZYTKOWNIK INTEGER,
   ZKPRCHR CHAR (1),
   DATA_UTW DATETIME,
   DATARDZIAL DATETIME,
   INSERTTMP INTEGER,
   ID_PL_ZUS INTEGER,
   CECHA_PLATNIKA CHAR(1),
   DOK_ZGLOSZ VARCHAR(5),
   NAZWA_SKR_B_RACH VARCHAR(31),
   NIP_B_RACH VARCHAR(10),
   REGON_B_RACH VARCHAR(14),
   STATUS_AKTYWNOSCI CHAR(1),
   STATUS_POTW_W_ZUS CHAR(1),
   ZNACZNIK_CZASU DATETIME,
   DATA_POTW_W_ZUS DATETIME,
   STATUS_WER_AUT CHAR(1),
   SKROT_DANYCH VARCHAR(40),
   NR_DZIAL SMALLINT,
   LICZBA_UBEZP INTEGER)
GO

CREATE TABLE dbo.ZUSZIUA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   I_1_ZGLZMDAIDOSUB CHAR(1),
   I_2_DATANADANIA DATETIME,
   I_3_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_PESEL VARCHAR(11),
   III_2_NIP VARCHAR(10),
   III_3_RODZDOK CHAR(1),
   III_4_SERIANRDOK VARCHAR(9),
   III_5_NAZWISKO VARCHAR(31),
   III_6_IMIEPIERW VARCHAR(22),
   III_7_DATAURODZ DATETIME,
   IV_1_PESEL VARCHAR(11),
   IV_2_NIP VARCHAR(10),
   IV_3_RODZDOK CHAR(1),
   IV_4_SERIANRDOK VARCHAR(9),
   IV_5_NAZWISKO VARCHAR(31),
   IV_6_IMIEPIERW VARCHAR(22),
   IV_7_DATAURODZ DATETIME,
   V_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.HISTORIA  (
   ID_UZYTKOWNIK INTEGER NOT NULL,
   HASLO VARCHAR(50) NOT NULL,
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.CERTYFIKAT  (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER,
   ID_UZYTKOWNIK INTEGER,
   CERT_TYP INTEGER,
   NUMER_SER VARCHAR (40),
   NAZWA_WYDAWCY VARCHAR (255),
   WLASCICIEL_ID VARCHAR (55),
   WLASCICIEL VARCHAR (255),
   NUMER_SER_WYD INTEGER,
   PRZEZNACZENIE SMALLINT,
   DT_CERT_OD DATETIME,
   DT_CERT_DO DATETIME,
   DT_KLUCZA_OD DATETIME,
   DT_KLUCZA_DO DATETIME,
   CERTYFIKAT TEXT,
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.BLAD_MIEDZY  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_ZESTAW INTEGER NOT NULL,
   TYP CHAR(1),
   NUMER INTEGER,
   KLASA INTEGER,
   INSERT_TMP INTEGER)
GO

CREATE TABLE dbo.ZUSZCNA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   I_1_DATANADANIA DATETIME,
   I_2_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_PESEL VARCHAR(11),
   III_2_NIP VARCHAR(10),
   III_3_RODZDOK CHAR(1),
   III_4_SERIANRDOK VARCHAR(9),
   III_5_NAZWISKO VARCHAR(31),
   III_6_IMIEPIERW VARCHAR(22),
   III_7_DATAURODZ DATETIME,
   VI_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   L_POZYCJI INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.PARAMETRY_PRZEKAZU  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   NAZWA VARCHAR(255),
   WARTOSC VARCHAR(255),
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.UBEZP_WYBOR  (ID_UBEZPIECZONY INTEGER NOT NULL,
   ID_PROGRAM INTEGER NOT NULL,
   WYBOR CHAR(1))
GO

CREATE TABLE dbo.ZUSZWPA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_WYRPLOSPRAWN CHAR(1),
   I_2_WYRPLOSFIZ CHAR(1),
   I_3_KORDANYCHWYRPL CHAR(1),
   I_4_DATANADANIA DATETIME,
   I_5_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_KODTYTWYRPL VARCHAR(3),
   III_2_DATAWYREJEST DATETIME,
   IV_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.ZUSRCA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_1IDRAPS VARCHAR(2),
   I_1_2OKRROZL VARCHAR(6),
   I_2_NRKARTKI_RCA NUMERIC(5),
   I_3_SKWNASTR_1_9 NUMERIC(9,2),
   I_4_SKWNASTR_2_9 NUMERIC(9,2),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   VII_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   ZN_KOR CHAR(1),
   ZN_KONW CHAR (1),
   SERIA INTEGER,
   L_POZYCJI INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.KODTYTUB  (KODTYTUB VARCHAR(6) NOT NULL)
GO

CREATE TABLE dbo.MIEJSCE  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_BLAD INTEGER NOT NULL,
   ID_DOKUMENT INTEGER NOT NULL,
   ID_BLOK INTEGER,
   TYP INTEGER,
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.UBEZP_ZUSRCA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   III_A_1_NAZWISKO VARCHAR(31),
   III_A_2_IMIEPIERW VARCHAR(22),
   III_A_3_TYPID CHAR(1),
   III_A_4_IDENTYFIK VARCHAR(11),
   III_B_1_1KODTYTUB VARCHAR(4),
   III_B_1_2PRDOEM CHAR(1),
   III_B_1_3STNIEP CHAR(1),
   III_B_2_INFOPRRPOD CHAR(1),
   III_B_3_1WYMCZPRL VARCHAR(3),
   III_B_3_2WYMCZPRM VARCHAR(3),
   III_B_4_PODWYMER NUMERIC(8,2),
   III_B_5_PODWYMCIW NUMERIC(8,2),
   III_B_6_PODWYMZDR NUMERIC(8,2),
   III_B_7_KWSKLEU_R NUMERIC(7,2),
   III_B_8_KWSKLRU_R NUMERIC(7,2),
   III_B_9_KWSKLCH_R NUMERIC(7,2),
   III_B_10_KWSKLZDR NUMERIC(7,2),
   III_B_11_KWSKLEP_R NUMERIC(7,2),
   III_B_12_KWSKLRP_R NUMERIC(7,2),
   III_B_13_KWSKLWYP NUMERIC(7,2),
   III_B_14_KWOBPROGE NUMERIC(7,2),
   III_B_15_LKWSKL NUMERIC(8,2),
   III_C_1_LOSZASRODZ VARCHAR(2),
   III_C_2_KWWYPZRODO NUMERIC(7,2),
   III_C_3_KWWYPZWYCH NUMERIC(7,2),
   III_C_4_LOSZASPIEL VARCHAR(2),
   III_C_5_KWWYPZPIEO NUMERIC(7,2),
   III_C_6_LKWWYPZ NUMERIC(8,2),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   STATUSWS INTEGER NOT NULL,
   INSERTTMP INTEGER,
   NRSCIEZWYL INTEGER,
   III_B_5_PODWYMCH NUMERIC(8,2),
   III_B_6_PODWYMWY NUMERIC(8,2),
   III_B_7_KWSKLEU_R_N NUMERIC(7,2),
   III_B_8_KWSKLRU_R_N NUMERIC(7,2),
   III_B_9_KWSKLCHU_R_N NUMERIC(7,2),
   III_B_10_KWSKLWYU_R NUMERIC(7,2),
   III_B_11_KWSKLEP_R_N NUMERIC(7,2),
   III_B_12_KWSKLRP_R_N NUMERIC(7,2),
   III_B_13_KWSKLCHP_R NUMERIC(7,2),
   III_B_14_KWSKLWYP_R NUMERIC(7,2),
   III_B_15_KWSKLEBP_R NUMERIC(7,2),
   III_B_16_KWSKLRBP_R NUMERIC(7,2),
   III_B_17_KWSKLCHBP_R NUMERIC(7,2),
   III_B_18_KWSKLWYBP_R NUMERIC(7,2),
   III_B_19_KWSKLEPFRON_R NUMERIC(7,2),
   III_B_20_KWSKLRPFRON_R NUMERIC(7,2),
   III_B_21_KWSKLCHPFRON_R NUMERIC(7,2),
   III_B_22_KWSKLWYPFRON_R NUMERIC(7,2),
   III_B_23_KWSKLEFK_R NUMERIC(7,2),
   III_B_24_KWSKLRFK_R NUMERIC(7,2),
   III_B_25_KWSKLCHFK_R NUMERIC(7,2),
   III_B_26_KWSKLWYFK_R NUMERIC(7,2),
   III_C_2_KWSKLZP_R NUMERIC(7,2),
   III_C_3_KWSKLZBP_R NUMERIC(7,2),
   III_C_4_KWSKLZU_R NUMERIC(7,2),
   III_C_5_KWSKLZFK_R NUMERIC(7,2),
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.ZUSRSA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_1IDRAPS VARCHAR(2),
   I_1_2OKRROZL VARCHAR(6),
   I_2_NRKARTKI_RSA NUMERIC(3),
   I_3_SKWNASTR_1_8 NUMERIC(8,2),
   I_4_SKWNASTR_2_8 NUMERIC(8,2),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   XI_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   ZN_KOR CHAR(1),
   ZN_KONW CHAR (1),
   SERIA INTEGER,
   L_POZYCJI INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.CRL  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER,
   WLASCICIEL_ID VARCHAR(55),
   WLASCICIEL VARCHAR(255),
   RODZAJ CHAR(1),
   NUMER INTEGER,
   SCIEZKA VARCHAR(255),
   TYP VARCHAR (20),
   DATA DATETIME,
   DATA_NAST DATETIME)
GO

CREATE TABLE dbo.CZR_ZUSZCZA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   IV_A_1_ZGLCZLWERA CHAR(1),
   IV_A_2_DATAUZUPRZD DATETIME,
   IV_A_3_PESEL VARCHAR(11),
   IV_A_4_NIP VARCHAR(10),
   IV_A_5_RODZDOK CHAR(1),
   IV_A_6_SERIANRDOK VARCHAR(9),
   IV_A_7_NAZWISKO VARCHAR(31),
   IV_A_8_IMIEPIERW VARCHAR(22),
   IV_A_9_DATAURODZ DATETIME,
   IV_A_10_KODSTPOKR VARCHAR(2),
   IV_A_11_NAUTRZOSUB CHAR(1),
   IV_A_12_POGOSPZUB CHAR(1),
   IV_A_13_STNIEP CHAR(1),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.DOKUMENT_PLATNICZY  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_DOKUMENT INTEGER,
   ID_PLATNIK INTEGER NOT NULL,
   NALTYTSKL CHAR(1),
   NRRACHUNKUZUS VARCHAR(26),
   TYPDOK CHAR(1),
   TYPWPLATY CHAR(1),
   KWOTA NUMERIC(12,2),
   NRRACHZLECENIODAWCY VARCHAR(36),
   NAZWASKR VARCHAR(54),
   NIP VARCHAR(10),
   TYPID VARCHAR(1),
   NRDECYZJI VARCHAR (15),
   IDENTYFIK VARCHAR(14),
   IDDEKLS CHAR(2),
   OKRESDEKLAR VARCHAR(6),
   DATA DATETIME,
   ODDZIALNADAWCA VARCHAR(30),
   ODDZIALADRESAT VARCHAR(30),
   WYDRUKOWANY CHAR(1),
   ID_UZYTKOWNIK INTEGER,
   STATUSWR CHAR(1),
   WERSJA_WER INTEGER,
   INSERTTMP INTEGER,
   SERIA INTEGER,
   ZAKRES INTEGER)
GO
 

CREATE TABLE dbo.ZUSZZA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   I_1_ZGLDOUBEZPZDR CHAR(1),
   I_2_ZGLZMDANYCH CHAR(1),
   I_3_DATANADANIA DATETIME,
   I_4_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_PESEL VARCHAR(11),
   III_2_NIP VARCHAR(10),
   III_3_RODZDOK CHAR(1),
   III_4_SERIANRDOK VARCHAR(9),
   III_5_NAZWISKO VARCHAR(31),
   III_6_IMIEPIERW VARCHAR(22),
   III_7_DATAURODZ DATETIME,
   IV_1_IMIEDRUGIE VARCHAR(22),
   IV_2_NAZWISKOROD VARCHAR(31),
   IV_3_OBYWATELSTWO VARCHAR(22),
   IV_4_PLEC CHAR(1),
   IV_5_KARTSTALPOB CHAR(1),
   IV_6_KARTACZASOPOB CHAR(1),
   V_1_1KODTYTUB VARCHAR(4),
   V_1_2PRDOEM CHAR(1),
   V_1_3STNIEP CHAR(1),
   VI_1_DATAPOWSOBUB DATETIME,
   VII_1_DATAPOWSOBUB DATETIME,
   VII_2_KWPIERSK NUMERIC(9,2),
   VIII_1_KODKASY VARCHAR(3),
   VIII_2_NAZWAKCH VARCHAR(23),
   VIII_3_DATAUMZKASA DATETIME,
   IX_1_KODPOCZTOWY VARCHAR(5),
   IX_2_MIEJSCOWOSC VARCHAR(26),
   IX_3_GMINA VARCHAR(26),
   IX_4_ULICA VARCHAR(30),
   IX_5_NUMERDOMU VARCHAR(7),
   IX_6_NUMERLOKALU VARCHAR(7),
   IX_7_TELEFON VARCHAR(12),
   IX_8_FAKS VARCHAR(12),
   X_1_KODPOCZTOWY VARCHAR(5),
   X_2_MIEJSCOWOSC VARCHAR(26),
   X_3_GMINA VARCHAR(26),
   X_4_ULICA VARCHAR(30),
   X_5_NUMERDOMU VARCHAR(7),
   X_6_NUMERLOKALU VARCHAR(7),
   X_7_TELEFON VARCHAR(12),
   X_8_FAKS VARCHAR(12),
   XI_1_KODPOCZTOWY VARCHAR(5),
   XI_2_MIEJSCOWOSC VARCHAR(26),
   XI_3_ULICA VARCHAR(30),
   XI_4_NUMERDOMU VARCHAR(7),
   XI_5_NUMERLOKALU VARCHAR(7),
   XI_6_SKRPOCZTOWA VARCHAR(5),
   XI_7_TELEFON VARCHAR(12),
   XI_8_FAKS VARCHAR(12),
   XI_9_ADRPOCZTYEL VARCHAR(30),
   XII_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   VII_2_KODNFZ VARCHAR(3),
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.UBEZP_ZUSRSA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   III_A_1_NAZWISKO VARCHAR(31),
   III_A_2_IMIEPIERW VARCHAR(22),
   III_A_3_TYPID CHAR(1),
   III_A_4_IDENTYFIK VARCHAR(11),
   III_B_1_1KODTYTUB VARCHAR(4),
   III_B_1_2PRDOEM CHAR(1),
   III_B_1_3STNIEP CHAR(1),
   III_B_2_KODSWPRZER VARCHAR(3),
   III_B_3_OKROD_RSA DATETIME,
   III_B_4_OKRDO_RSA DATETIME,
   III_B_5_LDNIZASILK VARCHAR(3),
   III_B_6_KODCHOROBY VARCHAR(2),
   III_B_7_KWOTASW NUMERIC(7,2),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   STATUSWS INTEGER NOT NULL,
   INSERTTMP INTEGER,
   ALGORYTM VARCHAR(3),
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.UZYTKOWNIK  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   LOGIN VARCHAR(14) NOT NULL,
   IMIE VARCHAR(30),
   NAZWISKO VARCHAR(30),
   HASLO VARCHAR(48),
   DATA_HASLA DATETIME,
   ID_PLATNIK INTEGER,
   STATUS CHAR(1),
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.ZUSZIPA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_ZGLZMDAOSPRAWN CHAR(1),
   I_2_ZGLZMDAOSFIZY CHAR(1),
   I_3_DATANADANIA DATETIME,
   I_4_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_NIP VARCHAR(10),
   III_2_REGON VARCHAR(14),
   III_3_PESEL VARCHAR(11),
   III_4_RODZDOK CHAR(1),
   III_5_SERIANRDOK VARCHAR(9),
   III_6_NAZWASKR VARCHAR(31),
   III_7_NAZWISKO VARCHAR(31),
   III_8_IMIEPIERW VARCHAR(22),
   III_9_DATAURODZ DATETIME,
   IV_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.ZUSZCZA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   I_1_DATANADANIA DATETIME,
   I_2_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_PESEL VARCHAR(11),
   III_2_NIP VARCHAR(10),
   III_3_RODZDOK CHAR(1),
   III_4_SERIANRDOK VARCHAR(9),
   III_5_NAZWISKO VARCHAR(31),
   III_6_IMIEPIERW VARCHAR(22),
   III_7_DATAURODZ DATETIME,
   VIII_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   L_POZYCJI INTEGER)
GO

CREATE TABLE dbo.UPRAWNIENIA  (ID_UZYTKOWNIK INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL)
GO

CREATE TABLE dbo.UBEZP_INNE (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   ID_DOKUMENT INTEGER,
   KODKASY VARCHAR(3),
   DATA_DOK DATETIME,
   ID_DOKUMENT_OBYW INTEGER,
   OBYWATELSTWO VARCHAR(22),
   DATA_DOK_OBYW DATETIME,
   STATUS_DANE CHAR(1),
   INSERTTMP INTEGER,
   ID_PL_ZUS INTEGER,
   ID_UB_ZUS INTEGER,
   DATA_ZGONU DATETIME, 
   DATA_AKT_DATY_ZGONU DATETIME,
   ZRODLO_ZGONU CHAR(1),
   IMIEDRUGIE VARCHAR(22),
   NAZWISKOROD VARCHAR(31),
   PLEC CHAR(1),
   CZY_RIA_UBEZP CHAR(1))
GO

CREATE TABLE dbo.UBEZP_KOD_PRACY (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   KODTYTUB VARCHAR(4),
   PRDOEM CHAR(1),
   STNIEP CHAR(1),
   KODPRSZW VARCHAR(3),
   DATAOD DATETIME,
   DATADO DATETIME,
   WYMCZPRL VARCHAR(3),
   WYMCZPRM VARCHAR(3),
   INSERTTMP INTEGER,
   ID_PL_ZUS INTEGER,
   ID_UB_ZUS INTEGER)
GO

CREATE TABLE dbo.PLATNIK_PARAMETR  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_NADRZEDNY INTEGER,
   ID_PLATNIK INTEGER NOT NULL,
   NAZWA VARCHAR(32),
   WARTOSC VARCHAR(20),
   DATAOD DATETIME,
   DATADO DATETIME,
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.PLATN_RACHBANK  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOKUMENT INTEGER,
   NR_RACH_BANK VARCHAR(36),
   KONTO_UBEZP CHAR(1),
   DATAOD DATETIME,
   STATUS_DANE CHAR(1),
   INSERTTMP INTEGER,
   ID_PL_ZUS INTEGER) 
GO

CREATE TABLE dbo.PLATN_RACHBANK_NRS(
	ID INTEGER IDENTITY(1,1) NOT NULL,
	ID_PLATNIK INTEGER NOT NULL,
	NR_RACH_BANK varchar(36) NULL,
	DATAOD datetime NULL,
	STATUS_DANE char(1) NULL,
	INSERTTMP INTEGER NULL,
	ID_PL_ZUS INTEGER NULL,
	ROLA char NULL,
	ZAKRES INTEGER,
 CONSTRAINT PLATRB_PK_NRS PRIMARY KEY (ID)
) 
GO

CREATE TABLE dbo.ZUSDRA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_TERMINDEKIRAP CHAR(1),
   I_2_1IDDEKLS VARCHAR(2),
   I_2_2OKRESDEKLAR VARCHAR(6),
   I_3_DATANADANIA DATETIME,
   I_4_NALEPKAR VARCHAR(20),
   I_5_ZNAKINRDECPOK VARCHAR(12),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_LUBEZP NUMERIC(6),
   III_2_LPRNAPELNYW NUMERIC(8,2),
   III_3_PLMASTPRCHR CHAR(1),
   III_4_STOPASKLWYP NUMERIC(4,2),
   IV_1_SSKLUBEM NUMERIC(11,2),
   IV_2_SSKLUBR NUMERIC(11,2),
   IV_3_SSKLUBEMR NUMERIC(11,2),
   IV_4_KWSKEMFUBD NUMERIC(11,2),
   IV_5_KWSKRENFUB NUMERIC(11,2),
   IV_6_SUMAKWEMRFPUB NUMERIC(11,2),
   IV_7_KWSKEMFPL NUMERIC(11,2),
   IV_8_KWSKRENFPL NUMERIC(11,2),
   IV_9_SKWEMIRENPPL NUMERIC(11,2),
   IV_10_KWSKEMBPD NUMERIC(11,2),
   IV_11_KWSKRENFBP NUMERIC(11,2),
   IV_12_SUMAKWEMRPBP NUMERIC(11,2),
   IV_13_KWSKEMFPF NUMERIC(11,2),
   IV_14_KWSKRENFPF NUMERIC(11,2),
   IV_15_SKWEMIRENPPF NUMERIC(11,2),
   IV_16_KWSKEMFKD NUMERIC(11,2),
   IV_17_KWSKRENFFK NUMERIC(11,2),
   IV_18_SKWEMIRENPFK NUMERIC(11,2),
   IV_19_SSKLUBCH NUMERIC(11,2),
   IV_20_SSKLUBWYP NUMERIC(11,2),
   IV_21_SSKLUBCHWYP NUMERIC(11,2),
   IV_22_KWSKCHUBD NUMERIC(11,2),
   IV_23_KWSKWFUB NUMERIC(11,2),
   IV_24_SKWCHIWYPPUB NUMERIC(11,2),
   IV_25_KWSKWFPL NUMERIC(11,2),
   IV_26_SKWCHIWYPPPL NUMERIC(11,2),
   IV_27_KWSKCHFPF NUMERIC(11,2),
   IV_28_KWSKWFPF NUMERIC(11,2),
   IV_29_SKWCHIWYPPPF NUMERIC(11,2),
   IV_30_KWSKWFFK NUMERIC(11,2),
   IV_31_SKWCHIWYPPFK NUMERIC(11,2),
   IV_32_KWSKSPOL NUMERIC(12,2),
   V_1_KWWYPSWZUBCH NUMERIC(11,2),
   V_2_KWNALWYNCH NUMERIC(11,2),
   V_3_KWWYPSWZUBWYP NUMERIC(11,2),
   V_4_KWWYPSWFINPBP NUMERIC(11,2),
   V_5_LKWDOPOTRDRA NUMERIC(12,2),
   VI_1_KWDOZWROTU_VI NUMERIC(12,2),
   VI_2_KWDOZAPP_VI NUMERIC(12,2),
   VII_1_KWSKDPRZPL NUMERIC(10,2),
   VII_2_KWSKLADFPFK NUMERIC(11,2),   
   VII_3_KWNALEZWY NUMERIC(10,2),
   VII_4_KWZAP NUMERIC(12,2),
   VIII_1_KWNALSKLFP NUMERIC(11,2),
   VIII_2_KWNALSKFGSP NUMERIC(11,2),
   VIII_3_KWZAPL_VIII NUMERIC(12,2),
   IX_1_LSUMAKWDOZAPL NUMERIC(12,2),
   /* ******** seria 7 ******* */
   IX_1_KWDOZWROTU NUMERIC(13,2),
   IX_2_KWDOZAPLATY NUMERIC(13,2),
   /* ******************* */
   
   X_1_KWDOPLNAUBSPOL NUMERIC(10,2),
   X_2_KWDOPLNAUBZDR NUMERIC(10,2),
   X_3_KWDOPFPIFGSP NUMERIC(10,2),
   X_4_LKWDOPLAT NUMERIC(11,2),
   XI_1_1KODTYTUB VARCHAR(4),
   XI_1_2PRDOEM CHAR(1),
   XI_1_3STNIEP CHAR(1),
   XI_2_PODSTWYMEIR NUMERIC(10,2),
   XI_3_PODSTWYMCHIW NUMERIC(10,2),
   XI_4_PODSTWYMZDR NUMERIC(10,2),
   XI_5_INFOPRRPOD CHAR(1),
   XII_1_LKARTEK_RCA VARCHAR(5),
   XII_2_LKARTEK_RNA VARCHAR(5),
   XII_3_LKARTEK_RZA VARCHAR(5),
   XII_4_LKARTEK_RSA VARCHAR(5),
   XII_5_LKARTEK_RGA VARCHAR(5),
   XII_6_LLICZKARTRAP VARCHAR(5),
   XII_7_1IDDEKLS VARCHAR(2),
   XII_7_2OKRESDEKLAR VARCHAR(6),
   XII_8_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   ZN_KOR CHAR(1),
   NRSCIEZWYL INTEGER,
   SERIA INTEGER,
   VII_3_KWSKLADFZBP NUMERIC(11,2),
   IX_1_LPRSKLADFEP NUMERIC(6),
   IX_2_LSTANPRSZW NUMERIC(6),
   IX_3_SSKLADFEP NUMERIC(12,2),
   IV_25_KWSKCHPD NUMERIC(11,2),
   IV_28_KWSKCHBPD NUMERIC(11,2),
   IV_29_KWSKWFBPD NUMERIC(11,2),
   IV_30_SKWCHIWYPPBP NUMERIC(11,2),
   IV_34_KWSKCHFKD  NUMERIC(11,2),
   VII_1_KWSKLADFPP NUMERIC(11,2),
   VII_2_KWSKLADFPUB NUMERIC(11,2),
   VII_5_KWSKDPRZPL NUMERIC(11,2),
   X_3_PODSTWYMCH NUMERIC(10,2),
   X_4_PODSTWYMWYP NUMERIC(10,2),
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.ZUSZFA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_ZGLPLSKLADE CHAR(1),
   I_2_ZGLZMDAPLATNIK CHAR(1),
   I_3_DATANADANIA DATETIME,
   I_4_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_IMIEDRUGIE VARCHAR(22),
   III_2_MIEJSCEUR VARCHAR(26),
   III_3_OBYWATELSTWO VARCHAR(22),
   IV_1_PODPOZROLDZIA VARCHAR(2),
   IV_2_NRUPRAWNIENIA VARCHAR(15),
   IV_3_NORGANUWYDUPR VARCHAR(72),
   IV_4_DATAWYDUPR DATETIME,
   IV_5_DATARDZIAL DATETIME,
   V_1_NRRACHUNKU VARCHAR(36),
   V_2_CZYINNERACH CHAR(1),
   VI_1_PLMASTPRCHR CHAR(1),
   VI_2_DATAOTSTPCHR DATETIME,
   VI_3_DATAUTRSTPRCH DATETIME,
   VI_4_DATAPOWOBUB DATETIME,
   VI_5_ADRDZIALNSIED CHAR(1),
   VII_1_KODPOCZTOWY VARCHAR(5),
   VII_2_MIEJSCOWOSC VARCHAR(26),
   VII_3_GMINA VARCHAR(26),
   VII_4_ULICA VARCHAR(30),
   VII_5_NUMERDOMU VARCHAR(7),
   VII_6_NUMERLOKALU VARCHAR(7),
   VII_7_TELEFON VARCHAR(12),
   VII_8_FAKS VARCHAR(12),
   VII_9_ADRPOCZTYEL VARCHAR(30),
   VIII_1_KODPOCZTOWY VARCHAR(5),
   VIII_2_MIEJSCOWOSC VARCHAR(26),
   VIII_3_GMINA VARCHAR(26),
   VIII_4_ULICA VARCHAR(30),
   VIII_5_NUMERDOMU VARCHAR(7),
   VIII_6_NUMERLOKALU VARCHAR(7),
   VIII_7_TELEFON VARCHAR(12),
   VIII_8_FAKS VARCHAR(12),
   VIII_9_ADRPOCZTYEL VARCHAR(30),
   IX_1_KODPOCZTOWY VARCHAR(5),
   IX_2_MIEJSCOWOSC VARCHAR(26),
   IX_3_ULICA VARCHAR(30),
   IX_4_NUMERDOMU VARCHAR(7),
   IX_5_NUMERLOKALU VARCHAR(7),
   IX_6_TELDOTELETR VARCHAR(12),
   IX_7_SKRPOCZTOWA VARCHAR(5),
   IX_8_TELEFON VARCHAR(12),
   IX_9_FAKS VARCHAR(12),
   IX_10_ADRPOCZTYEL VARCHAR(30),
   X_1_NIP VARCHAR(10),
   X_2_REGON VARCHAR(14),
   X_3_NAZWASKR VARCHAR(31),
   XI_1_LZALZBA VARCHAR(3),
   XI_2_LZALZAA VARCHAR(3),
   XI_3_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.ZESTAW_DOKUM  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_ZESTAW INTEGER NOT NULL,
   ID_DOKUMENT INTEGER NOT NULL,
   STATUS CHAR(1),
   INSERTTMP INTEGER,
   NR_DOKUMENT INTEGER,
   KOLEJNOSC INTEGER)
GO

CREATE TABLE dbo.WIADOMOSC  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER,
   ID_UZYTKOWNIK INTEGER,
   TYP VARCHAR(3),
   DATA DATETIME,
   WIAD_ROD CHAR(1),
   WIAD_TYP CHAR (1),
   TRANSAKCJA_ID INTEGER,
   WIAD_ID_SKOJ INTEGER,
   PLIK TEXT,
   RODZAJ CHAR(1),
   KOD VARCHAR(3),
   GRID_OPIS VARCHAR(255),
   STATUS VARCHAR(10),
   PRZYJMUJACY_ID VARCHAR(8),
   PLATNIK_ID VARCHAR(55),
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.DZIENNIK  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER,
   ID_UZYTKOWNIK INTEGER,
   CZAS DATETIME NOT NULL,
   ID_ZDARZENIA INTEGER NOT NULL,
   ID_POMOCNICZY INTEGER,
   OPIS VARCHAR(255),
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.ARCH_DZIENNIK  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER,
   ID_UZYTKOWNIK INTEGER,
   CZAS DATETIME NOT NULL,
   ID_ZDARZENIA INTEGER NOT NULL,
   ID_POMOCNICZY INTEGER,
   OPIS VARCHAR(255),
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.ZUSRNA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_1IDRAPS VARCHAR(2),
   I_1_2OKRROZL VARCHAR(6),
   I_2_NRKARTKI_RNA NUMERIC(5),
   I_3_SKWNASTR_1_10 NUMERIC(10,2),
   I_4_SKWNASTR_2_10 NUMERIC(10,2),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   V_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   ZN_KOR CHAR(1),
   SERIA INTEGER,
   L_POZYCJI INTEGER)
GO

CREATE TABLE dbo.ZUSZUA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   I_1_ZGLDOUBSPOLZDR CHAR(1),
   I_2_ZGLDOUBSPOL CHAR(1),
   I_3_ZGZMKOROSUB CHAR(1),
   I_4_DATANADANIA DATETIME,
   I_5_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_PESEL VARCHAR(11),
   III_2_NIP VARCHAR(10),
   III_3_RODZDOK CHAR(1),
   III_4_SERIANRDOK VARCHAR(9),
   III_5_NAZWISKO VARCHAR(31),
   III_6_IMIEPIERW VARCHAR(22),
   III_7_DATAURODZ DATETIME,
   IV_1_IMIEDRUGIE VARCHAR(22),
   IV_2_NAZWISKOROD VARCHAR(31),
   IV_3_OBYWATELSTWO VARCHAR(22),
   IV_4_PLEC CHAR(1),
   IV_5_KARTSTALPOB CHAR(1),
   IV_6_KARTACZASOPOB CHAR(1),
   V_1_1KODTYTUB VARCHAR(4),
   V_1_2PRDOEM CHAR(1),
   V_1_3STNIEP CHAR(1),
   V_2_1OKRESNIEPOD DATETIME,
   V_2_2OKRESNIEPDO DATETIME,
   VI_1_1WYMCZPRL VARCHAR(3),
   VI_1_2WYMCZPRM VARCHAR(3),
   VI_2_DATAPOWSOBUB DATETIME,
   VI_3_OSZGPODLEM CHAR(1),
   VI_4_OSZGPODREN CHAR(1),
   VI_5_OSZGPODLCH CHAR(1),
   VI_6_OSZGPODLWYP CHAR(1),
   VII_1_DATAPOWSOBUB DATETIME,
   VIII_1_WNOOBJEM CHAR(1),
   VIII_2_ODDNIAUBEM DATETIME,
   VIII_3_WNOOBJR CHAR(1),
   VIII_4_ODDNIAUBR DATETIME,
   VIII_5_WNOOBJCH CHAR(1),
   VIII_6_ODDNIAUBCH DATETIME,
   IX_1_DATAPOWSOBUB DATETIME,
   IX_2_KWPIERSK NUMERIC(9,2),
   X_1_KODPOKZPRAC VARCHAR(2),
   X_2_WSPGOSPZPR CHAR(1),
   X_3_KODSTNZDPRA VARCHAR(2),
   X_4_1OKRNZDOPROD DATETIME,
   X_4_2OKRNZDOPRDO DATETIME,
   X_5_KODZAWODU VARCHAR(7),
   X_6_KODPRGORN VARCHAR(6),
   X_7_1OKRPRGOROD DATETIME,
   X_7_2OKRPRGORDO DATETIME,
   X_8_KODWYK VARCHAR(2),
   X_9_KODPRSZW VARCHAR(9),
   X_10_1OKRPRSZWOD DATETIME,
   X_10_2OKRPRSZWDO DATETIME,
   XI_1_KODKASY VARCHAR(3),
   XI_2_NAZWAKCH VARCHAR(23),
   XI_3_DATAUMZKASA DATETIME,
   XII_1_KODPOCZTOWY VARCHAR(5),
   XII_2_MIEJSCOWOSC VARCHAR(26),
   XII_3_GMINA VARCHAR(26),
   XII_4_ULICA VARCHAR(30),
   XII_5_NUMERDOMU VARCHAR(7),
   XII_6_NUMERLOKALU VARCHAR(7),
   XII_7_TELEFON VARCHAR(12),
   XII_8_FAKS VARCHAR(12),
   XIII_1_KODPOCZTOWY VARCHAR(5),
   XIII_2_MIEJSCOWOSC VARCHAR(26),
   XIII_3_GMINA VARCHAR(26),
   XIII_4_ULICA VARCHAR(30),
   XIII_5_NUMERDOMU VARCHAR(7),
   XIII_6_NUMERLOKALU VARCHAR(7),
   XIII_7_TELEFON VARCHAR(12),
   XIII_8_FAKS VARCHAR(12),
   XIV_1_KODPOCZTOWY VARCHAR(5),
   XIV_2_MIEJSCOWOSC VARCHAR(26),
   XIV_3_ULICA VARCHAR(30),
   XIV_4_NUMERDOMU VARCHAR(7),
   XIV_5_NUMERLOKALU VARCHAR(7),
   XIV_6_SKRPOCZTOWA VARCHAR(5),
   XIV_7_TELEFON VARCHAR(12),
   XIV_8_FAKS VARCHAR(12),
   XIV_9_ADRPOCZTYEL VARCHAR(30),
   XV_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   IX_2_KODNFZ VARCHAR(3),
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.NIEJED  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK1 INTEGER,
   TYP1 INTEGER,
   ID_DOK2 INTEGER,
   TYP2 INTEGER,
   ID_DOK3 INTEGER,
   STATUS CHAR(1),
   TYP INTEGER,
   ID_PROGRAM INTEGER)
GO

CREATE TABLE dbo.UBEZP_ZUSRNA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   III_A_1_NAZWISKO VARCHAR(31),
   III_A_2_IMIEPIERW VARCHAR(22),
   III_A_3_TYPID CHAR(1),
   III_A_4_IDENTYFIK VARCHAR(11),
   III_B_1_1KODTYTUB VARCHAR(4),
   III_B_1_2PRDOEM CHAR(1),
   III_B_1_3STNIEP CHAR(1),
   III_B_2_INFOPRRPOD CHAR(1),
   III_B_3_1WYMCZPRL VARCHAR(3),
   III_B_3_2WYMCZPRM VARCHAR(3),
   III_B_4_PODWYMER NUMERIC(8,2),
   III_B_5_PODWYMCIW NUMERIC(8,2),
   III_B_6_PODWYMZDR NUMERIC(8,2),
   III_B_7_KWSKLEU_R NUMERIC(7,2),
   III_B_8_KWSKLRU_R NUMERIC(7,2),
   III_B_9_KWSKLCH_R NUMERIC(7,2),
   III_B_10_KWSKLZDR NUMERIC(7,2),
   III_B_11_KWSKLEP_R NUMERIC(7,2),
   III_B_12_KWSKLRP_R NUMERIC(7,2),
   III_B_13_KWSKLWYP NUMERIC(7,2),
   III_B_14_KWOBPROGE NUMERIC(7,2),
   III_B_15_LKWSKL NUMERIC(8,2),
   III_C_1_LOSZASRODZ VARCHAR(2),
   III_C_2_KWWYPZRODO NUMERIC(7,2),
   III_C_3_KWWYPZWYCH NUMERIC(7,2),
   III_C_4_LOSZASPIEL VARCHAR(2),
   III_C_5_KWWYPZPIEO NUMERIC(7,2),
   III_C_6_LKWWYPZ NUMERIC(8,2),
   III_D_1_DNIPRZEPR VARCHAR(2),
   III_D_2_LDNIOBPR VARCHAR(2),
   III_D_3_KODSKL_1 VARCHAR(2),
   III_D_4_OKROD_1 DATETIME,
   III_D_5_OKRDO_1 DATETIME,
   III_D_6_KW_RNA_1 NUMERIC(8,2),
   III_D_7_KODSKL_2 VARCHAR(2),
   III_D_8_OKROD_2 DATETIME,
   III_D_9_OKRDO_2 DATETIME,
   III_D_10_KW_RNA_2 NUMERIC(8,2),
   III_D_11_KODSKL_3 VARCHAR(2),
   III_D_12_OKROD_3 DATETIME,
   III_D_13_OKRDO_3 DATETIME,
   III_D_14_KW_RNA_3 NUMERIC(8,2),
   III_D_15_KODSKL_4 VARCHAR(2),
   III_D_16_OKROD_4 DATETIME,
   III_D_17_OKRDO_4 DATETIME,
   III_D_18_KW_RNA_4 NUMERIC(8,2),
   III_D_19_KODSKL_5 VARCHAR(2),
   III_D_20_OKROD_5 DATETIME,
   III_D_21_OKRDO_5 DATETIME,
   III_D_22_KW_RNA_5 NUMERIC(8,2),
   III_D_23_KODSKL_6 VARCHAR(2),
   III_D_24_OKROD_6 DATETIME,
   III_D_25_OKRDO_6 DATETIME,
   III_D_26_KW_RNA_6 NUMERIC(8,2),
   III_D_27_KODSKL_7 VARCHAR(2),
   III_D_28_OKROD_7 DATETIME,
   III_D_29_OKRDO_7 DATETIME,
   III_D_30_KW_RNA_7 NUMERIC(8,2),
   III_D_31_KODSKL_8 VARCHAR(2),
   III_D_32_OKROD_8 DATETIME,
   III_D_33_OKRDO_8 DATETIME,
   III_D_34_KW_RNA_8 NUMERIC(8,2),
   III_D_35_KODSKL_9 VARCHAR(2),
   III_D_36_OKROD_9 DATETIME,
   III_D_37_OKRDO_9 DATETIME,
   III_D_38_KW_RNA_9 NUMERIC(8,2),
   III_D_39_KODSKL_10 VARCHAR(2),
   III_D_40_OKROD_10 DATETIME,
   III_D_41_OKRDO_10 DATETIME,
   III_D_42_KW_RNA_10 NUMERIC(8,2),
   III_D_43_SUMAKWOT NUMERIC(9,2),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   STATUSWS INTEGER NOT NULL,
   INSERTTMP INTEGER,
   NRSCIEZWYL INTEGER)
GO

CREATE TABLE dbo.SDWI_KODTYTUB  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_SDWIUBEZPIECZONY INTEGER NOT NULL,
   ID_SDWINAGLOWEK INTEGER NOT NULL,
   KODTYTUB VARCHAR(6),
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.SDWI_UBEZPIECZONY  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_SDWINAGLOWEK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER,
   PESEL VARCHAR(11),
   NIP VARCHAR(10),
   RODZDOK CHAR(1),
   SERIANRDOK VARCHAR(9),
   NAZWISKO VARCHAR(31),
   IMIEPIERW VARCHAR(22),
   DATAURODZ DATETIME,
   NAZWISKOROD VARCHAR(31),
   IMIEDRUGIE VARCHAR(22),
   KODKASY VARCHAR(3),
   NAZWAKCH VARCHAR(23),
   TYP_ADRESU CHAR(1),
   KODPOCZTOWY VARCHAR(5),
   MIEJSCOWOSC VARCHAR(26),
   GMINA VARCHAR(26),
   ULICA VARCHAR(30),
   NUMERDOMU VARCHAR(7),
   NUMERLOKALU VARCHAR(7),
   SKRPOCZTOWA VARCHAR(5),
   TELEFON VARCHAR(12),
   FAKS VARCHAR(12),
   ADRPOCZTYEL VARCHAR(30),
   DATAOD DATETIME,
   STATUSWR CHAR(1),
   STATUS_SDWI CHAR(1),
   KODTYTUB VARCHAR(50),
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.SDWI_NAGLOWEK  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PRZESYLKI CHAR(30),
   SKROT VARCHAR (40),
   OKRROZL VARCHAR(6),
   DATAWYGWYC DATETIME,
   NIP VARCHAR(10),
   REGON VARCHAR(14),
   PESEL VARCHAR(11),
   RODZDOK CHAR(1),
   SERIANRDOK VARCHAR(9),
   NAZWASKR VARCHAR(31),
   NAZWISKO VARCHAR(31),
   IMIEPIERW VARCHAR(22),
   STATUS_SDWI CHAR(1),
   DATAURODZ DATETIME,
   INSERTTMP INTEGER,
   L_POZYCJI INTEGER)
GO

CREATE TABLE dbo.PLIK_DOKUM  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_DOKUMENT INTEGER,
   ID_PLIK INTEGER,
   ID_IMPORT INTEGER,
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.ARCHIWUM_O (ID INTEGER IDENTITY (1, 1) NOT NULL,
  TYP_ARCHIWUM CHAR (1) NOT NULL ,
  STATUSARCH CHAR (1),
  ID_PLATNIK INT,
  ID_ZESTAW INT,
  NUMER INT,
  NAZWA vARCHAR (255),
  DATA_WYS DATETIME,
  DATA_POTW DATETIME,
  DATA_ARCH DATETIME,
  DATA_ODTW DATETIME,
  TRYBARCH CHAR (1),
  INSERTTMP INT,
  ID_PROGRAM INT) 
GO

CREATE TABLE dbo.ARCHIWUM_I (ID INT IDENTITY (1, 1) NOT NULL,
  ID_ARCH_O_ROB INT,
  TYP_ARCHIWUM CHAR (1) NOT NULL,
  ID_AO_ODTW INT,
  ID_PLATNIK INT,
  ID_PLATNIK_ROB INT,
  ID_ZESTAW INT,
  ID_ZESTAW_ROB INT,
  DATA_ARCH DATETIME,
  TRYBARCH CHAR (1),
  INSERTTMP INT,
  ID_PROGRAM INT) 
GO

CREATE TABLE dbo.PARAM_KONF  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   NAZWA VARCHAR(255),
   WARTOSC1 VARCHAR(255),
   WARTOSC2 TEXT,
   WARTOSC3 INTEGER)
GO

CREATE TABLE dbo.PARAM_PLAT_UZYT  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER,
   ID_UZYTKOWNIK INTEGER,
   NAZWA VARCHAR(55),
   WARTOSC VARCHAR(10),
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.OSOBA_PRYWATNA  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_UZYTKOWNIK INTEGER NOT NULL,
   NIP VARCHAR(10),
   PESEL VARCHAR(11),
   RODZDOK CHAR(1),
   SERIANRDOK VARCHAR(9),
   WOJEWODZTWO VARCHAR(26),
   MIEJSCOWOSC VARCHAR(26),
   KODPOCZTOWY VARCHAR(5),
   ULICA VARCHAR(30),
   NUMERDOMU VARCHAR(7),
   NUMERLOKALU VARCHAR(7),
   STATUSWR CHAR(1),
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.POTWIERDZENIE  (ID INTEGER IDENTITY (1, 1) NOT NULL,
  ID_PLATNIK INTEGER NOT NULL,
  NAZWA_KEDU TEXT,
  NAZWA_KSI TEXT,
  KEDU_KSI_ID VARCHAR (34),
  DATA_PRZYG DATETIME,
  DATA_POTW DATETIME,
  PRZYG_OPIS TEXT,
  POTW_OPIS TEXT,
  POTW_JEDN_ZUS  VARCHAR (128),
  PLIK_POTW TEXT,
  SKROT VARCHAR (128),
  INSERTTMP INTEGER)
GO

CREATE TABLE dbo.ZUSIWA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_1IDINFOR VARCHAR(2),
   I_1_2OKRINFOR VARCHAR(4),
   I_2_KODJEDNTER VARCHAR(6),
   I_3_DATANADANIA DATETIME,
   I_4_NALEPKAR VARCHAR(20),
   I_5_DATAWPL DATETIME,
   I_6_ZNAKINRDECPOK CHAR(12),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_LUBEZP NUMERIC(6),
   IV_1_RDZIALPKD VARCHAR(5),
   IV_2_LPSZKWYP NUMERIC(6),
   IV_3_LPSZWYPSMC NUMERIC(6),
   IV_4_LZTRWARZAG NUMERIC(6),
   V_1_KODPOCZTOWY VARCHAR(5),
   V_2_MIEJSCOWOSC VARCHAR(26),
   V_3_ULICA VARCHAR(30),
   V_5_NUMERLOKALU VARCHAR(7),
   V_4_NUMERDOMU VARCHAR(7),
   V_6_TELDOTELETR VARCHAR(12),
   V_7_SKRPOCZTOWA VARCHAR(5),
   V_8_TELEFON VARCHAR(12),
   V_9_FAKS VARCHAR(12),
   V_10_ADRPOCZTYEL VARCHAR(30),
   VI_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.ZUSZSWA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,      
   I_1_1IDZGLOSZ VARCHAR(3),
   I_1_2OKRESZGL VARCHAR(4),
   I_2_DATANADANIA DATETIME,
   I_3_NALEPKAR VARCHAR(20),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   VII_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   L_POZYCJI INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.UBEZP_ZUSZSWA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   III_A_1_ZGLDAPRSZW CHAR(1),
   III_A_2_ZGLKORDAPRSZW CHAR(1),
   III_A_3_PESEL VARCHAR(11),
   III_A_4_NIP VARCHAR(10),
   III_A_5_RODZDOK CHAR(1),
   III_A_6_SERIANRDOK VARCHAR(9),
   III_A_7_NAZWISKO VARCHAR(31),
   III_A_8_IMIEPIERW VARCHAR(22),
   III_A_9_DATAURODZ DATETIME,
   III_B_1_1KODTYTUB VARCHAR(4),
   III_B_1_2PRDOEM CHAR(1),
   III_B_1_3STNIEP CHAR(1),
   III_B_2_KODPRSZW VARCHAR(3),
   III_B_3_KODPRSZWOD DATETIME,
   III_B_4_KODPRSZWDO DATETIME,
   III_B_5_1WYMCZPRL VARCHAR(3),
   III_B_5_2WYMCZPRM VARCHAR(3),
   III_B_6_KODPRSZW VARCHAR(3),
   III_B_7_KODPRSZWOD DATETIME,
   III_B_8_KODPRSZWDO DATETIME,
   III_B_9_1WYMCZPRL VARCHAR(3),
   III_B_9_2WYMCZPRM VARCHAR(3),
   III_B_10_KODPRSZW VARCHAR(3),
   III_B_11_KODPRSZWOD DATETIME,
   III_B_12_KODPRSZWDO DATETIME,
   III_B_13_1WYMCZPRL VARCHAR(3),
   III_B_13_2WYMCZPRM VARCHAR(3),
   III_B_14_KODPRSZW VARCHAR(3),
   III_B_15_KODPRSZWOD DATETIME,
   III_B_16_KODPRSZWDO DATETIME,
   III_B_17_1WYMCZPRL VARCHAR(3),
   III_B_17_2WYMCZPRM VARCHAR(3),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   STATUS_KONTROLI CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.PRZESYLKA  (ID INTEGER IDENTITY (1, 1) NOT NULL,
  ID_RODZIC INTEGER,
  ID_POTOMEK INTEGER,
  POZIOM INTEGER,
  ID_PLATNIK INTEGER NOT NULL,
  PLATNIK INTEGER,
  ID_UZYTKOWNIK INTEGER,
  RODZAJ CHAR (1),
  TYP CHAR (1),
  NADAWCA VARCHAR (255),
  ODBIORCA VARCHAR (255),
  ID_ZAWARTOSC INTEGER,
  NAZWA_ZAWARTOSC VARCHAR (255),
  DOTYCZY VARCHAR (255),
  KOD_BLEDU INTEGER,
  STATUS VARCHAR (255),
  DATA_UTW DATETIME,
  DATA_WYS_ODB DATETIME,
  ID_PRZESYLKI VARCHAR (40),
  ID_DO_ZUS VARCHAR (40),
  ID_Z_ZUS VARCHAR (40),
  ADRESHTTP VARCHAR (50),
  KANAL CHAR(1),
  SKROT VARCHAR (128),
  SC_DO_PRZES TEXT,
  SC_DO_CMS TEXT,	
  FORMAT INTEGER,	
  WIELKOSC INTEGER,	
  SKROT_DIME VARCHAR (128),	
  UPOWAZNIENIE CHAR (1),
  ID_PLATNIK_UPOW INTEGER,
  INFO_PRODUCENT VARCHAR (64),
  INFO_PROGRAM VARCHAR (64),
  INFO_WERSJA VARCHAR (32),
  CERT_RODZAJ CHAR (1),
  CERT_NUMSER VARCHAR (40),
  CERT_WYSTAWCA VARCHAR (255),
  SPOSOB CHAR (1),
  INSERTTMP INTEGER)
GO

CREATE TABLE dbo.ZAMOWIENIE  (ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   NIP VARCHAR(10),
   REGON VARCHAR(14),
   PESEL VARCHAR(11),
   RODZDOK CHAR(1),
   SERIANRDOK VARCHAR(9),
   NAZWASKR VARCHAR(31),
   NAZWISKO VARCHAR(31),
   IMIEPIERW VARCHAR(22),
   DATAURODZ DATETIME,
   OKR_ROZL VARCHAR(6),
   STATUSPT CHAR(1),
   NUMER INTEGER,
   TYP CHAR(1),
   DATA_UTW DATETIME,
   DATA_WYS DATETIME,
   KANAL CHAR(1),
   UWAGI TEXT,
   ID_PRZESYLKA INTEGER,
   SKROT VARCHAR (40),
   NAZWA_PLIKU  TEXT,   
   ID_POTW VARCHAR(35),   
   STATUSPT_AT TEXT,
   POTWIERDZENIE TEXT,
   DATA_POTW DATETIME,
   INSERTTMP INTEGER)
GO

CREATE TABLE dbo.INFOUDO (ID int IDENTITY (1, 1) NOT NULL,
  ID_PLATNIK INTEGER NOT NULL,
  ID_UZYTKOWNIK INTEGER NOT NULL,
  ID_ZDARZENIA INTEGER,
  CZAS DATETIME,
  TYP INTEGER,
  DATA datetime,
  IDRAPS VARCHAR(2),
  OKRROZL VARCHAR(6),
  ID_PROGRAM INTEGER,
  INSERTTMP INTEGER)
GO

CREATE TABLE dbo.INFOUDO_UBEZP (ID INTEGER IDENTITY (1, 1) NOT NULL,
  ID_INFOUDO INTEGER NOT NULL,
  ID_UBEZPIECZONY INTEGER NOT NULL,
  ID_PROGRAM INTEGER NULL,
  INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.LISTA_DZIENNIK (ID_ZDARZENIA INTEGER,
  NAZWA VARCHAR(255))
GO

CREATE TABLE dbo.KOMUNIKAT (
   ID_KOMUNIKAT INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_BIURO INTEGER NULL,
   ID_KOM_ZUS VARCHAR(50) NOT NULL,
   DATA_PUBLIKACJI DATETIME NULL,
   DATA_WAZNOSCI DATETIME NULL,
   DATA_REJESTRACJI DATETIME NULL,
   TYTUL VARCHAR(255) NULL,
   TRESC TEXT NULL,
   LICZBA_ZAL SMALLINT NULL,
   STATUS SMALLINT NULL,
   STAT_CZYT SMALLINT NOT NULL,
   INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.ZALACZNIK (
   ID_ZALACZNIK INTEGER IDENTITY (1, 1) NOT NULL,
   ID_KOMUNIKAT INTEGER NOT NULL,
   LP SMALLINT NOT NULL,
   OPIS VARCHAR(255) NULL,
   LOKALIZACJA TEXT NULL,
   TYP VARCHAR(50) NULL,
   INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.PLATN_HIST (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PLATNIK_HIST INTEGER NOT NULL,
   DATADO DATETIME NULL,
   INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.PLATNIK_ZUS (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   NAZWASKR VARCHAR(31) NULL,
   STATUSWR CHAR(1) NULL,
   STATUSPT CHAR(1) NULL,
   IDBIURARACH INTEGER NULL,
   DATAOD DATETIME NULL,
   DATADO DATETIME NULL,
   ID_DOK_ZGL INTEGER NULL,
   ID_DOK_WYR INTEGER NULL,
   ID_UZYTKOWNIK INTEGER NULL,
   ZKPRCHR CHAR(1) NULL,
   DATA_UTW DATETIME NULL,
   DATARDZIAL DATETIME NULL,
   INSERTTMP INTEGER NULL,
   ID_PL_ZUS INTEGER NULL,
   CECHA_PLATNIKA CHAR(1) NULL,
   DOK_ZGLOSZ VARCHAR(5) NULL,
   NAZWA_SKR_B_RACH VARCHAR(31) NULL,
   NIP_B_RACH VARCHAR(10) NULL,
   REGON_B_RACH VARCHAR(14) NULL,
   STATUS_AKTYWNOSCI CHAR(1) NULL,
   STATUS_POTW_W_ZUS CHAR(1) NULL,
   ZNACZNIK_CZASU DATETIME NULL,
   DATA_POTW_W_ZUS DATETIME NULL,
   STATUS_WER_AUT CHAR(1) NULL,
   SKROT_DANYCH VARCHAR(40) NULL,
   NR_DZIAL SMALLINT NULL,
   LICZBA_UBEZP INTEGER NULL
)
GO

CREATE TABLE dbo.PLATN_OBOWOPLSKL (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL, 
   DATAOD DATETIME NULL,
   DATADO DATETIME NULL,
   STATUS_DANE CHAR(1) NULL,
   INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.PLATN_OBOWIWA (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL, 
   ROK DATETIME NULL,
   STATUS_ZAPISU CHAR(1) NULL,
   DATA_USTALENIA_ZAPISU DATETIME NULL,
   STATUS_DANE CHAR(1) NULL,
   INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.PLATN_SALDA (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL, 
   SALDO_WN	NUMERIC(15,2),
   DATA_OST_OBR DATETIME NULL,
   ZAKRES INTEGER,
   INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.PLATN_KALK_ODS
(
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL, 
   ZAKRES INTEGER,
   DATA_BAZOWA_ODS DATETIME NULL,
   ODS_DZIEN_01 NUMERIC(10,2),
   ODS_DZIEN_02 NUMERIC(10,2),
   ODS_DZIEN_03 NUMERIC(10,2),
   ODS_DZIEN_04 NUMERIC(10,2),
   ODS_DZIEN_05 NUMERIC(10,2),
   ODS_DZIEN_06 NUMERIC(10,2),
   ODS_DZIEN_07 NUMERIC(10,2),
   ODS_DZIEN_08 NUMERIC(10,2),
   ODS_DZIEN_09 NUMERIC(10,2),
   ODS_DZIEN_10 NUMERIC(10,2),
   ODS_DZIEN_11 NUMERIC(10,2),
   ODS_DZIEN_12 NUMERIC(10,2),
   ODS_DZIEN_13 NUMERIC(10,2),
   ODS_DZIEN_14 NUMERIC(10,2),
   ODS_DZIEN_15 NUMERIC(10,2),
   ODS_DZIEN_16 NUMERIC(10,2),
   ODS_DZIEN_17 NUMERIC(10,2),
   ODS_DZIEN_18 NUMERIC(10,2),
   ODS_DZIEN_19 NUMERIC(10,2),
   ODS_DZIEN_20 NUMERIC(10,2),
   ODS_DZIEN_21 NUMERIC(10,2),
   ODS_DZIEN_22 NUMERIC(10,2),
   ODS_DZIEN_23 NUMERIC(10,2),
   ODS_DZIEN_24 NUMERIC(10,2),
   ODS_DZIEN_25 NUMERIC(10,2),
   ODS_DZIEN_26 NUMERIC(10,2),
   ODS_DZIEN_27 NUMERIC(10,2),
   ODS_DZIEN_28 NUMERIC(10,2),
   ODS_DZIEN_29 NUMERIC(10,2),
   ODS_DZIEN_30 NUMERIC(10,2),
   ODS_DZIEN_31 NUMERIC(10,2),
   ODS_DZIEN_32 NUMERIC(10,2),
   ODS_DZIEN_33 NUMERIC(10,2),
   ODS_DZIEN_34 NUMERIC(10,2),
   ODS_DZIEN_35 NUMERIC(10,2),
   ODS_DZIEN_36 NUMERIC(10,2),
   ODS_DZIEN_37 NUMERIC(10,2),
   ODS_DZIEN_38 NUMERIC(10,2),
   ODS_DZIEN_39 NUMERIC(10,2),
   ODS_DZIEN_40 NUMERIC(10,2),
   ODS_DZIEN_41 NUMERIC(10,2),
   ODS_DZIEN_42 NUMERIC(10,2),
   ODS_DZIEN_43 NUMERIC(10,2),
   ODS_DZIEN_44 NUMERIC(10,2),
   ODS_DZIEN_45 NUMERIC(10,2),
   ODS_DZIEN_46 NUMERIC(10,2),
   ODS_DZIEN_47 NUMERIC(10,2),
   ODS_DZIEN_48 NUMERIC(10,2),
   ODS_DZIEN_49 NUMERIC(10,2),
   ODS_DZIEN_50 NUMERIC(10,2),
   ODS_DZIEN_51 NUMERIC(10,2),
   ODS_DZIEN_52 NUMERIC(10,2),
   ODS_DZIEN_53 NUMERIC(10,2),
   ODS_DZIEN_54 NUMERIC(10,2),
   ODS_DZIEN_55 NUMERIC(10,2),
   ODS_DZIEN_56 NUMERIC(10,2),
   ODS_DZIEN_57 NUMERIC(10,2),
   ODS_DZIEN_58 NUMERIC(10,2),
   ODS_DZIEN_59 NUMERIC(10,2),
   ODS_DZIEN_60 NUMERIC(10,2),
   ODS_DZIEN_61 NUMERIC(10,2),
   ODS_DZIEN_62 NUMERIC(10,2),
   INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.PLATN_STATUS (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL, 
   DATAOD DATETIME NULL,
   DATADO DATETIME NULL,
   WARTOSC CHAR(1) NULL,
   STATUS_DANE CHAR(1) NULL,
   INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.PLATN_IWA (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL,
   I_1_1IDINFOR INTEGER NULL,
   I_1_2OKRINFOR DATETIME NULL,
   VI_1_DATAWYPEL DATETIME NULL,
   INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.PLATN_ZSWA (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL,
   I_1_1IDZGLOSZ INTEGER NULL,
   I_1_2OKRESZGL DATETIME NULL,
   INSERTTMP INTEGER NULL)
GO

CREATE TABLE dbo.UBEZPIECZONY_ZUS (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ATRYBUT_I INTEGER NULL,
   ATRYBUT_II INTEGER NULL,
   STATUSWR CHAR(1) NULL,
   STATUSPT CHAR(1) NULL,
   ID_UZYTKOWNIK INTEGER NULL,
   DATA_UTW DATETIME NULL,
   INSERTTMP INTEGER NULL,
   ID_PL_ZUS INTEGER NULL,
   ID_UB_ZUS INTEGER NULL,
   STATUS_POTW_W_ZUS CHAR(1) NULL,
   ZNACZNIK_CZASU DATETIME NULL,
   DATA_POTW_W_ZUS DATETIME NULL,
   STATUS_WER_AUT CHAR(1) NULL,
   SKROT_DANYCH VARCHAR(40) NULL
)
GO

CREATE TABLE dbo.UBEZP_CZLONEK_RODZINY (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL,
   ID_UB_ZUS INTEGER NULL,
   IMIEPIERW VARCHAR(22) NULL,
   NAZWISKO VARCHAR(31) NULL,
   NIP VARCHAR(10) NULL,
   PESEL VARCHAR(11) NULL,
   RODZDOK CHAR(1) NULL,
   SERIANRDOK VARCHAR(9) NULL,
   STNIEP CHAR(1) NULL,
   KODSTPOKR CHAR(2) NULL,
   POGOSPZUB CHAR(1) NULL,
   DATAURODZ DATETIME NULL,
   DATA_UZYSKANIA_UPRAWNIEN DATETIME NULL,
   DATA_UTRATY_UPRAWNIEN DATETIME NULL,
   INSERTTMP INTEGER NULL
)
GO

CREATE TABLE dbo.UBEZP_30KROTNOSC (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL,
   ID_UB_ZUS INTEGER NULL,
   ROK SMALLINT NULL,
   MIESIAC_PRZEKROCZENIA SMALLINT NULL,
   INSERTTMP INTEGER NULL
)
GO

CREATE TABLE dbo.UBEZP_PODLEGANIE (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   ID_PL_ZUS INTEGER NULL,
   ID_UB_ZUS INTEGER NULL,
   KODTYTUB VARCHAR(4) NULL,
   PRDOEM CHAR(1) NULL,
   STNIEP CHAR(1) NULL,
   DATAOD DATETIME NULL,
   DATADO DATETIME NULL,
   EMER_PODLEGANIE CHAR(1) NULL,
   RENT_PODLEGANIE CHAR(1) NULL,
   CHOR_PODLEGANIE CHAR(1) NULL,
   WYP_PODLEGANIE CHAR(1) NULL,
   ZDROW_PODLEGANIE CHAR(1) NULL,
   NUMER_SCHEMATU INTEGER NULL,
   TYP_DOK_WYREJ INTEGER NULL,
   DATA_WYPELDOKWYREJ DATETIME NULL,
   ZWUA_V_DATAROZWYGSTPS datetime NULL,
   INSERTTMP INTEGER NULL
)
GO

CREATE TABLE dbo.UBEZP_INDSCHEMAT (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   NUMER_SCHEMATU INTEGER NULL,
   RODZAJ CHAR(1) NULL,
   EMER_PODLEGANIE CHAR(1) NULL,
   EMER_ZR1 VARCHAR(2) NULL,
   EMER_PROC1 NUMERIC(5,4) NULL,
   EMER_ZR2 VARCHAR(2) NULL,
   EMER_PROC2 NUMERIC(5,4) NULL,
   RENT_PODLEGANIE CHAR(1) NULL,
   RENT_ZR1 VARCHAR(2) NULL,
   RENT_PROC1 NUMERIC(5,4) NULL,
   RENT_ZR2 VARCHAR(2) NULL,
   RENT_PROC2 NUMERIC(5,4) NULL,
   CHOR_PODLEGANIE CHAR(1) NULL,
   CHOR_ZR1 VARCHAR(2) NULL,
   WYP_PODLEGANIE CHAR(1) NULL,
   WYP_ZR1 VARCHAR(2) NULL,
   WYP_PROC1 NUMERIC(5,4) NULL,
   WYP_ZR2 VARCHAR(2) NULL,
   WYP_PROC2 NUMERIC(5,4) NULL,
   ZDROW_PODLEGANIE CHAR(1) NULL,
   ZDROW_ZR1 VARCHAR(2) NULL,
   INSERTTMP INTEGER NULL
)
GO

CREATE TABLE dbo.KOMPLET_DOKROZL (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NULL,
   ID_PL_ZUS INTEGER NOT NULL,
   ID_KOMPL_ZUS INTEGER NULL,
   NR_KOMPLETU INTEGER NULL,
   OKRES_ROZLICZ DATETIME NULL,
   ZAKRES SMALLINT NULL,
   PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
   ZNACZNIK_CZASU DATETIME NULL,
   DATA_POTW_W_ZUS DATETIME NULL,
   SKROT_DANYCH VARCHAR(40) NULL,
   INSERTTMP INTEGER NULL
)
GO

CREATE TABLE dbo.DOKROZL_DEKLARACJA (
   ID_DOKUMENT INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NULL,
   ID_KOMPLET INTEGER NULL,
   ID_WDR_ZUS INTEGER NULL,
   ID_DOK_ZUS INTEGER NULL,
   ID_PL_ZUS INTEGER NULL,
   ID_KOMPL_ZUS INTEGER NULL,
   PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
   I_2_1 INTEGER NULL,
   I_2_2 DATETIME NULL,
   III_1 INTEGER NULL,
   III_2 CHAR(1) NULL,
   III_3 NUMERIC(5,2) NULL,
   IV_1 NUMERIC(15,2) NULL,
   IV_2 NUMERIC(15,2) NULL,
   IV_3 NUMERIC(15,2) NULL,
   IV_4 NUMERIC(15,2) NULL,
   IV_5 NUMERIC(15,2) NULL,
   IV_6 NUMERIC(15,2) NULL,
   IV_7 NUMERIC(15,2) NULL,
   IV_8 NUMERIC(15,2) NULL,
   IV_9 NUMERIC(15,2) NULL,
   IV_10 NUMERIC(15,2) NULL,
   IV_11 NUMERIC(15,2) NULL,
   IV_12 NUMERIC(15,2) NULL,
   IV_13 NUMERIC(15,2) NULL,
   IV_14 NUMERIC(15,2) NULL,
   IV_15 NUMERIC(15,2) NULL,
   IV_16 NUMERIC(15,2) NULL,
   IV_17 NUMERIC(15,2) NULL,
   IV_18 NUMERIC(15,2) NULL,
   IV_19 NUMERIC(15,2) NULL,
   IV_20 NUMERIC(15,2) NULL,
   IV_21 NUMERIC(15,2) NULL,
   IV_22 NUMERIC(15,2) NULL,
   IV_23 NUMERIC(15,2) NULL,
   IV_24 NUMERIC(15,2) NULL,
   IV_25 NUMERIC(15,2) NULL,
   IV_26 NUMERIC(15,2) NULL,
   IV_27 NUMERIC(15,2) NULL,
   IV_28 NUMERIC(15,2) NULL,
   IV_29 NUMERIC(15,2) NULL,
   IV_30 NUMERIC(15,2) NULL,
   IV_31 NUMERIC(15,2) NULL,
   IV_32 NUMERIC(15,2) NULL,
   IV_33 NUMERIC(15,2) NULL,
   IV_34 NUMERIC(15,2) NULL,
   IV_35 NUMERIC(15,2) NULL,
   IV_36 NUMERIC(15,2) NULL,
   IV_37 NUMERIC(15,2) NULL,
   V_1 NUMERIC(15,2) NULL,
   V_2 NUMERIC(15,2) NULL,
   V_3 NUMERIC(15,2) NULL,
   V_4 NUMERIC(15,2) NULL,
   V_5 NUMERIC(15,2) NULL,
   VI_1 NUMERIC(12,2) NULL,
   VI_2 NUMERIC(12,2) NULL,
   VII_1 NUMERIC(11,2) NULL,
   VII_2 NUMERIC(11,2) NULL,
   VII_3 NUMERIC(11,2) NULL,
   VII_4 NUMERIC(11,2) NULL,
   VII_5 NUMERIC(11,2) NULL,
   VII_6 NUMERIC(11,2) NULL,
   VII_7 NUMERIC(12,2) NULL,
   VIII_1 NUMERIC(11,2) NULL,
   VIII_2 NUMERIC(11,2) NULL,
   VIII_3 NUMERIC(12,2) NULL,
   IX_1 INTEGER NULL,
   IX_2 INTEGER NULL,
   IX_3 NUMERIC(12,2) NULL,
   X_1_1 VARCHAR(4) NULL,
   X_1_2 CHAR(1) NULL,
   X_1_3 CHAR(1) NULL,
   X_2 NUMERIC(11,2) NULL,
   X_3 NUMERIC(11,2) NULL,
   X_4 NUMERIC(11,2) NULL,
   X_5 NUMERIC(11,2) NULL,
   X_6 CHAR(1) NULL,
	IX_KWOTA_DO_ZWROTU NUMERIC(13,2),
	IX_KWOTA_DO_ZAPL NUMERIC(13,2),
   INSERTTMP INTEGER NULL
)
GO

CREATE TABLE dbo.DOKROZL_RAPORT (
   ID_DOKUMENT INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PLATNIK INTEGER NULL,
   ID_KOMPLET INTEGER NULL,
   ID_DOK_ZUS INTEGER NULL,
   ID_PL_ZUS INTEGER NULL,
   ID_KOMPL_ZUS INTEGER NULL,
   PODNR_KOMPLETU INTEGER NULL DEFAULT 0,
   TYP INTEGER NOT NULL,
   I_1_1 INTEGER NULL,
   I_1_2 DATETIME NULL,
   INSERTTMP INTEGER NULL
)
GO

CREATE TABLE dbo.UBEZP_SKLAD (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_DOKUMENT INTEGER NULL,
   ID_PLATNIK INTEGER NULL,
   ID_UBEZPIECZONY INTEGER NULL,
   ID_DOK_ZUS INTEGER NULL,
   NR_PODDOKUMENTU INTEGER NULL,
   ID_PL_ZUS INTEGER NULL,
   ID_UB_ZUS INTEGER NULL,
   TYP INTEGER NOT NULL,
   III_A_1 VARCHAR(31) NULL,
   III_A_2 VARCHAR(22) NULL,
   III_A_3 CHAR(1) NULL,
   III_A_4 VARCHAR(11) NULL,
   III_B_1_1 VARCHAR(4) NULL,
   III_B_1_2 CHAR(1) NULL,
   III_B_1_3 CHAR(1) NULL,
   III_B_2 CHAR(1) NULL,
   III_B_3_1 SMALLINT NULL,
   III_B_3_2 SMALLINT NULL,
   III_B_4 NUMERIC(15,2) NULL,
   III_B_5 NUMERIC(15,2) NULL,
   III_B_6 NUMERIC(15,2) NULL,
   III_B_7 NUMERIC(15,2) NULL,
   III_B_8 NUMERIC(15,2) NULL,
   III_B_9 NUMERIC(15,2) NULL,
   III_B_10 NUMERIC(15,2) NULL,
   III_B_11 NUMERIC(15,2) NULL,
   III_B_12 NUMERIC(15,2) NULL,
   III_B_13 NUMERIC(15,2) NULL,
   III_B_14 NUMERIC(15,2) NULL,
   III_B_15 NUMERIC(15,2) NULL,
   III_B_16 NUMERIC(15,2) NULL,
   III_B_17 NUMERIC(15,2) NULL,
   III_B_18 NUMERIC(15,2) NULL,
   III_B_19 NUMERIC(15,2) NULL,
   III_B_20 NUMERIC(15,2) NULL,
   III_B_21 NUMERIC(15,2) NULL,
   III_B_22 NUMERIC(15,2) NULL,
   III_B_23 NUMERIC(15,2) NULL,
   III_B_24 NUMERIC(15,2) NULL,
   III_B_25 NUMERIC(15,2) NULL,
   III_B_26 NUMERIC(15,2) NULL,
   III_B_27 NUMERIC(15,2) NULL,
   III_B_28 NUMERIC(15,2) NULL,
   III_C_1 NUMERIC(15,2) NULL,
   III_C_2 NUMERIC(15,2) NULL,
   III_C_3 NUMERIC(15,2) NULL,
   III_C_4 NUMERIC(15,2) NULL,
   III_C_5 NUMERIC(15,2) NULL,
   III_D_1 NUMERIC(7,2) NULL,
   III_D_2 NUMERIC(7,2) NULL,
   III_D_3 NUMERIC(7,2) NULL,
   III_D_4 NUMERIC(8,2) NULL,
   INSERTTMP INTEGER NULL
)
GO

CREATE TABLE dbo.UBEZP_SWIAD (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_DOKUMENT INTEGER NULL,
   ID_PLATNIK INTEGER NULL,
   ID_UBEZPIECZONY INTEGER NULL,
   ID_DOK_ZUS INTEGER NULL,
   NR_PODDOKUMENTU INTEGER NULL,
   ID_PL_ZUS INTEGER NULL,
   ID_UB_ZUS INTEGER NULL,
   III_A_1 VARCHAR(31) NULL,
   III_A_2 VARCHAR(22) NULL,
   III_A_3 CHAR(1) NULL,
   III_A_4 VARCHAR(11) NULL,
   III_B_1_1 VARCHAR(4) NULL,
   III_B_1_2 CHAR(1) NULL,
   III_B_1_3 CHAR(1) NULL,
   III_B_2 VARCHAR(3) NULL,
   III_B_3 DATETIME NULL,
   III_B_4 DATETIME NULL,
   III_B_5 INTEGER NULL,
   III_B_6 NUMERIC(7,2) NULL,
   INSERTTMP INTEGER NULL
)
GO

CREATE TABLE dbo.BLAD_PRZETW (
   ID INTEGER IDENTITY (1, 1) NOT NULL,
   ID_PRZESYLKI VARCHAR(40) NOT NULL,
   ID_DOKUMENT INTEGER NOT NULL,
   KOD_BLEDU INTEGER NOT NULL,
   NR_POZYCJI INTEGER NULL,
   INSERTTMP INTEGER NULL
)
GO

CREATE TABLE dbo.TMP_UBEZPIECZENI (
   ID_UB_ZUS INTEGER NOT NULL,
   ID_PROGRAM INTEGER NOT NULL,
   KROK_UBEZPIECZONY_ZUS SMALLINT,
   KROK_UBEZP_30KROTNOSC SMALLINT,
   KROK_UBEZP_ADRES SMALLINT,
   KROK_UBEZP_CZLONEK_RODZINY SMALLINT,
   KROK_UBEZP_IDENT SMALLINT,
   KROK_UBEZP_INDSCHEMAT SMALLINT,
   KROK_UBEZP_INNE SMALLINT,
   KROK_UBEZP_KOD_PRACY SMALLINT,
   KROK_UBEZP_PODLEGANIE SMALLINT,
   KROK_PLATN_DRA2RCA2 SMALLINT,
   KROK_PLATN_MDG SMALLINT 
)
GO

CREATE TABLE dbo.TMP_OKRESY (
   ID_PROGRAM INTEGER NOT NULL,   
   OKRES DATETIME NOT NULL,
   PRZEDZIALID SMALLINT NULL
)
GO

CREATE TABLE dbo.LISTA_ODDZIAL (
  ID INTEGER NOT NULL,
  NAZWAODDZIAL VARCHAR(31) NOT NULL,
  INSERTTMP INTEGER)
GO

CREATE TABLE dbo.ZUSOSW  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_NIP VARCHAR(10),
   I_2_REGON VARCHAR(14),
   I_3_PESEL VARCHAR(11),
   I_4_RODZDOK CHAR(1),
   I_5_SERIANRDOK VARCHAR(9),
   I_6_NAZWASKR VARCHAR(31),
   I_7_NAZWISKO VARCHAR(31),
   I_8_IMIEPIERW VARCHAR(22),
   I_9_DATAURODZ DATETIME,
   II_1_RAPORTYTAK CHAR(1),
   II_2_RAPORTYNIE CHAR(1),
   III_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.ZUSRPA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_1IDRAPS VARCHAR(2),
   I_1_2OKRROZL VARCHAR(6),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   IV_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   ZN_KOR CHAR(1),
   ZN_KONW CHAR (1),
   SERIA INTEGER,
   L_POZYCJI INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.UBEZP_ZUSRPA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   III_A_1_NAZWISKO VARCHAR(31),
   III_A_2_IMIEPIERW VARCHAR(22),
   III_A_3_TYPID CHAR(1),
   III_A_4_IDENTYFIK VARCHAR(11),
   III_A_5_1KODTYTUB VARCHAR(4),
   III_A_5_2PRDOEM CHAR(1),
   III_A_5_3STNIEP CHAR(1),
   III_B_1_ROK SMALLINT NULL,
   III_B_2_KWOTA NUMERIC(8,2),
   III_B_3_ROK SMALLINT NULL,
   III_B_4_KWOTA NUMERIC(8,2),
   III_B_5_ROK SMALLINT NULL,
   III_B_6_KWOTA NUMERIC(8,2),
   III_C_1_ROK SMALLINT NULL,
   III_C_2_KWOTA NUMERIC(8,2),
   III_C_3_ROK SMALLINT NULL,
   III_C_4_KWOTA NUMERIC(8,2),
   III_C_5_ROK SMALLINT NULL,
   III_C_6_KWOTA NUMERIC(8,2),
   III_D_1_KWOTA NUMERIC(8,2),
   III_E_1_ROK SMALLINT NULL,
   III_E_2_KWOTA NUMERIC(8,2),
   III_E_3_ROK SMALLINT NULL,
   III_E_4_KWOTA NUMERIC(8,2),
   III_E_5_ROK SMALLINT NULL,
   III_E_6_KWOTA NUMERIC(8,2),
   III_F_1_OKRESOD DATETIME,
   III_F_2_OKRESDO DATETIME,
   III_F_3_1WYMZAJL VARCHAR(3),
   III_F_3_2WYMZAJM VARCHAR(3),
   III_F_4_OKRESOD DATETIME,
   III_F_5_OKRESDO DATETIME,
   III_F_6_1WYMZAJL VARCHAR(3),
   III_F_6_2WYMZAJM VARCHAR(3),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   STATUSWS INTEGER NOT NULL,
   INSERTTMP INTEGER,
   NRSCIEZWYL INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.ZUSRIA  (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   I_1_RODZAJ_DOKUMENTU CHAR(1),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_NAZWISKO VARCHAR(31),
   III_2_IMIEPIERW VARCHAR(22),
   III_3_TYPID CHAR(1),
   III_4_IDENTYFIK VARCHAR(11),
   IV_1_DATAROZWYG DATETIME,
   IV_2_KODROZWYG VARCHAR(3),
   IV_3_KODPODPRAWROZWY VARCHAR(3),
   IV_4_PODPRAWROZWYG VARCHAR(180),
   IV_5_STRONAROZWYG SMALLINT,
   X_1_STATUS_PODMIOTU CHAR(1),
   XII_1_DATAWYPEL DATETIME,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   ZN_KOR CHAR(1),
   ZN_KONW CHAR (1),
   SERIA INTEGER,
   L_POZYCJI INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1),
   ID_UB_ZUS_STATUS CHAR(1))
GO

CREATE TABLE dbo.BLK_RIA_PRZYCHOD (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   TYP_BLOKU INTEGER NOT NULL,
   V_VI_VII_1_ROKWYPLAT SMALLINT,
   V_VI_VII_2_PRZYZAROK SMALLINT,
   V_VI_VII_3_KWOTAPRZY NUMERIC(15,2),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   STATUSWS INTEGER NOT NULL,
   INSERTTMP INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.BLK_RIA_PRACA_NAUCZYCIEL (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   TYP_BLOKU INTEGER NOT NULL,
   VIII_IX_1_OKRESOD DATETIME,
   VIII_IX_2_OKRESDO DATETIME,
   VIII_IX_3_1_LWYMCZASUPR  VARCHAR(3),
   VIII_IX_3_2_MWYMCZASUPR  VARCHAR(3),
   VIII_IX_4_OBNIZWYMIA CHAR(1),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   STATUSWS INTEGER NOT NULL,
   INSERTTMP INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.BLK_RIA_EME_FUS (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   TYP_BLOKU INTEGER NOT NULL,
   X_2_OKRESOD DATETIME,
   X_3_OKRESDO DATETIME,    
   X_4_PRACAWPELWYM VARCHAR(1),
   X_5_1_LWYMCZASUPRACY INTEGER,
   X_5_2_MWYMCZASUPRACY INTEGER,
   X_6_KODPRACYSZCHAR VARCHAR(9),
   X_7_KODPRACYSZWAR1 VARCHAR(9),
   X_8_NAZWASTANSZWAR1 VARCHAR(36),
   X_9_ZMNAZWASTANSZW1 VARCHAR(36),
   X_10_KODPRACYSZWAR2 VARCHAR(9),
   X_11_NAZWASTANSZWAR2 VARCHAR(36),
   X_12_ZMNAZWASTANSZW2 VARCHAR(36),
   X_13_DEPUTATWEGLOWY VARCHAR(1),
   X_14_ZATRUDNAKOLEI VARCHAR(1),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   STATUSWS INTEGER NOT NULL,
   INSERTTMP INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.BLK_RIA_EME_POMOSTOWE (ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   ID_DOK_NAD INTEGER NOT NULL,
   ID_UBEZPIECZONY INTEGER NOT NULL,
   TYP_BLOKU INTEGER NOT NULL,
   XI_1_KODPRACY VARCHAR(3),
   XI_2_OKRESOD DATETIME,
   XI_3_OKRESDO DATETIME,
   XI_4_1_LWYMCZASUPRACY INTEGER,
   XI_4_2_MWYMCZASUPRACY INTEGER,
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   STATUSWS INTEGER NOT NULL,
   INSERTTMP INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   NR_BLOK INTEGER)
GO

CREATE TABLE dbo.ZUSDRA2RCA2  (
   ID_DOKUMENT INTEGER NOT NULL,
   ID_PLATNIK INTEGER NOT NULL,
   I_1_IDENTYFIKATOR CHAR(2),
   I_2_ROK CHAR(4),
   I_3_DATANADANIA DATETIME,
   I_4_NALEPKAR VARCHAR(20),
   I_5_ZNAKINRDECPOK VARCHAR(12),
   II_1_NIP VARCHAR(10),
   II_2_REGON VARCHAR(14),
   II_3_PESEL VARCHAR(11),
   II_4_RODZDOK CHAR(1),
   II_5_SERIANRDOK VARCHAR(9),
   II_6_NAZWASKR VARCHAR(31),
   II_7_NAZWISKO VARCHAR(31),
   II_8_IMIEPIERW VARCHAR(22),
   II_9_DATAURODZ DATETIME,
   III_1_PRZYCHOD NUMERIC(10,2),
   III_2_PODSTAWA NUMERIC(10,2),
III_DOCHOD NUMERIC(10, 2) NULL,
IV_PRZYCHOD_KARTA NUMERIC(10, 2) ,
IV_DOCHOD_KARTA NUMERIC(10, 2) ,
IV_PRZYCHOD_RYCZALT NUMERIC(10, 2) ,
IV_DOCHOD_RYCZALT NUMERIC(10, 2) ,
IV_PRZYCHOD_OGOLNE NUMERIC(10, 2) ,
IV_DOCHOD_OGOLNE NUMERIC(10, 2),

   
   IV_1_DATAWYPELN DATETIME,
   TYP_DOK CHAR(3),
   STATUSWR CHAR(1),
   STATUSPT CHAR(1),
   INSERTTMP INTEGER,
   SERIA INTEGER,
   STATUSZUS CHAR(1),
   STATUS_KONTROLI CHAR(1),
   ID_PL_ZUS_STATUS CHAR(1))
GO

CREATE TABLE PLATN_OSWRIA(
	ID integer IDENTITY(1,1) NOT NULL,
	ID_PL_ZUS bigint NULL,
	ID_PLATNIK INTEGER,
	STATUS_OSW nchar(1) NULL,
	DATA_WYPEL_ZGL_OSW datetime NULL,
	DATA_WYPEL_ODW_OSW datetime NULL,
	CZY_RIA_PLATNIK nchar(1) NULL,	
	INSERTTMP INTEGER,
	CONSTRAINT PK_PLATN_OSWRIA PRIMARY KEY (ID)
)
GO

CREATE TABLE PLATN_DRA2RCA2(
	ID integer IDENTITY(1,1) NOT NULL,
	ID_PLATNIK INTEGER,
	ID_DOKUMENTU integer NULL,
	TYP_DOK char(3) NULL,
	I_ID_DEKLARACJI smallint NULL,
	I_ROK_PODST_SKL	smallint NULL,
	III_PRZYCHOD_DZIAL decimal(10,2) NULL,
	III_NAJN_PODSTAWA decimal(10,2) NULL,
III_DOCHOD NUMERIC(10, 2) NULL,
IV_PRZYCHOD_KARTA NUMERIC(10, 2) ,
IV_DOCHOD_KARTA NUMERIC(10, 2) ,
IV_PRZYCHOD_RYCZALT NUMERIC(10, 2) ,
IV_DOCHOD_RYCZALT NUMERIC(10, 2) ,
IV_PRZYCHOD_OGOLNE NUMERIC(10, 2) ,
IV_DOCHOD_OGOLNE NUMERIC(10, 2),
	IV_DATA_WYPEL datetime null,
	ID_PL_ZUS bigint NULL,
	ID_UB_ZUS bigint NULL,
	NR_DZIAL_PLAT smallint NULL,
	INSERTTMP INTEGER,
	CONSTRAINT PK_PLATN_DRA2RCA2 PRIMARY KEY (ID)
)
GO

CREATE TABLE UBEZP_RPA(
	ID integer IDENTITY(1,1) NOT NULL,
	ID_DOKUMENT integer NULL,
	ID_PLATNIK integer NULL,
	ID_UBEZPIECZONY integer NULL,
	ID_DOK_ZUS integer NULL,
	NR_PODDOKUMENTU integer NULL,
	ID_PL_ZUS integer NULL,
	ID_UB_U_PLAT integer NULL,
	ID_UB_ZUS integer NULL,
	ID_WEW_DRA integer NULL,
	STATUS_KONTROLI nchar(1) NULL,
	I_OKRES_RAPORTU datetime NULL,
	III_NAZWISKO nvarchar(50) NULL,
	III_IMIE_PIERWSZE nvarchar(50) NULL,
	III_RODZAJ_DOK nvarchar(1 ) NULL,
	III_IDENT_DOK nvarchar(50) NULL,
	III_KOD_UBEZP nvarchar(4) NULL,
	III_PRAWO_DO_EME nvarchar(1) NULL,
	III_KOD_STOPNIA_NIEP nvarchar(1) NULL,
	III_PRZY_ROK_E_1  integer,
	III_PRZY_KWOTA_E_1 decimal(15,2),
	III_PRZY_ROK_E_2 integer,
	III_PRZY_KWOTA_E_2 decimal(15,2),
	III_PRZY_ROK_E_3 integer,
	III_PRZY_KWOTA_E_3 decimal(15,2),
	III_PRZY_ROK_W_1 integer,
	III_PRZY_KWOTA_W_1 decimal(15,2),
	III_PRZY_ROK_W_2 integer,
	III_PRZY_KWOTA_W_2 decimal(15,2),
	III_PRZY_ROK_W_3 integer,
	III_PRZY_KWOTA_W_3 decimal(15,2),
	III_PRZY_KWOTA_N_B decimal(15,2),
	III_PRZY_ROK_N_1 integer,
	III_PRZY_KWOTA_N_1 decimal(15,2),
	III_PRZY_ROK_N_2 integer,
	III_PRZY_KWOTA_N_2 decimal(15,2),
	III_PRZY_ROK_N_3 integer,
	III_PRZY_KWOTA_N_3 decimal(15,2),
	III_NAU_OKRES_OD_1 datetime,
	III_NAU_OKRES_DO_1 datetime,
	III_NAU_LICZ_W_C_1 varchar(3),
	III_NAU_MIAN_W_C_1 varchar(3),
	III_NAU_OKRES_OD_2 datetime,
	III_NAU_OKRES_DO_2 datetime,
	III_NAU_LICZ_W_C_2 varchar(3),
	III_NAU_MIAN_W_C_2 varchar(3),
	INSERTTMP INTEGER,
	CONSTRAINT PK_UBEZP_RPA PRIMARY KEY (ID)
)
GO



CREATE TABLE PLATN_MDG(
	ID integer IDENTITY(1,1) NOT NULL,
	ID_PLATNIK INTEGER,
	ID_PL_ZUS INTEGER,
	ID_UB_ZUS INTEGER,
	LICZBA_DNI_DZIAL INTEGER,
	DATA_CZAS_REJ datetime,
	ROK_DNI_DZIAL INTEGER,
	INSERTTMP INTEGER,
	CONSTRAINT PK_PLATN_MDG PRIMARY KEY (ID)
);

ALTER TABLE dbo.PLATN_HIST ADD CONSTRAINT PLATNH_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATNIK_ZUS ADD CONSTRAINT PLAT_ZUS_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATN_OBOWOPLSKL ADD CONSTRAINT PLATNOBSKL_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATN_OBOWIWA ADD CONSTRAINT PLATNOBIWA_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATN_KALK_ODS ADD CONSTRAINT PLATNKALKODS_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATN_SALDA ADD CONSTRAINT PLATNSALDA_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATN_STATUS ADD CONSTRAINT PLATNST_PK PRIMARY KEY (ID)
GO


ALTER TABLE dbo.PLATN_IWA ADD CONSTRAINT PLATNIWA_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATN_ZSWA ADD CONSTRAINT PLATNZSWA_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZPIECZONY_ZUS ADD CONSTRAINT UBEZP_ZUS_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZP_CZLONEK_RODZINY ADD CONSTRAINT UBEZPCZR_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZP_30KROTNOSC ADD CONSTRAINT UBEZP30KROT_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZP_PODLEGANIE ADD CONSTRAINT UBEZPPODL_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZP_INDSCHEMAT ADD CONSTRAINT UBEZPINDSCH_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.KOMPLET_DOKROZL ADD CONSTRAINT KOMPLDOKROZL_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.DOKROZL_DEKLARACJA ADD CONSTRAINT DOKROZLDEKL_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.DOKROZL_RAPORT ADD CONSTRAINT DOKROZLRAP_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.UBEZP_SKLAD ADD CONSTRAINT UBEZPSKLAD_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZP_SWIAD ADD CONSTRAINT UBEZPSWIAD_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.BLAD_PRZETW ADD CONSTRAINT BLADPRZETW_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.TMP_UBEZPIECZENI ADD CONSTRAINT TMP_UBEZP_PK PRIMARY KEY (ID_UB_ZUS, ID_PROGRAM)
GO

ALTER TABLE dbo.KOMUNIKAT ADD CONSTRAINT PK_KOMUNIKAT PRIMARY KEY (ID_KOMUNIKAT)
GO

ALTER TABLE dbo.ZALACZNIK ADD CONSTRAINT PK_ZALACZNIK PRIMARY KEY (ID_ZALACZNIK)
GO

ALTER TABLE dbo.KOMUNIKAT WITH NOCHECK ADD
	CONSTRAINT DF_KOMUNIKAT_LICZBA_ZAL DEFAULT (0) FOR LICZBA_ZAL,
	CONSTRAINT DF_KOMUNIKAT_STATUS DEFAULT (0) FOR STATUS,
	CONSTRAINT DF_KOMUNIKAT_STAT_CZYT DEFAULT (0) FOR STAT_CZYT
GO

ALTER TABLE dbo.INFOUDO ADD CONSTRAINT PK_INFOUDO PRIMARY KEY (ID)
GO

ALTER TABLE dbo.INFOUDO_UBEZP ADD CONSTRAINT PK_INFO_UBEZP PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PRZESYLKA ADD CONSTRAINT PK_PRZESYLKA PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZAMOWIENIE ADD CONSTRAINT PK_ZAMOWIENIE PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSIWA ADD CONSTRAINT IWA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.POTWIERDZENIE ADD CONSTRAINT POTW_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.OSOBA_PRYWATNA ADD CONSTRAINT OSOB_PRW_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PARAM_PLAT_UZYT ADD CONSTRAINT PAR_PL_UZ_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PARAM_KONF ADD CONSTRAINT KONFIGUR_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ARCHIWUM_O ADD CONSTRAINT PK_ID_ARCH_O PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ARCHIWUM_I ADD CONSTRAINT PK_ID_ARCH_I PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLIK_DOKUM ADD CONSTRAINT PDM_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.SDWI_KODTYTUB ADD CONSTRAINT SKB_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.SDWI_UBEZPIECZONY ADD CONSTRAINT SUI_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.SDWI_NAGLOWEK ADD CONSTRAINT SNK_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.KODSWPRZ ADD CONSTRAINT KODSW_PK PRIMARY KEY (KODSWPRZ)
GO

ALTER TABLE dbo.UBEZPIECZONY ADD CONSTRAINT UBEZP_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.DOKUMENT ADD CONSTRAINT DOK_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.UBEZP_ADRES ADD CONSTRAINT UAE_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.BLAD_DOK ADD CONSTRAINT BLDOK_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.TMP_TAB ADD CONSTRAINT TMP_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSZBA ADD CONSTRAINT ZBA_PK PRIMARY KEY (ID_DOKUMENT)
GO
 
ALTER TABLE dbo.BLOKADA ADD CONSTRAINT BLOK_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSZAA ADD CONSTRAINT ZAA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.ZESTAW_DOKUM ADD CONSTRAINT ZESTDOK_PK PRIMARY KEY (ID)
GO
 
ALTER TABLE dbo.ZESTAW ADD CONSTRAINT ZEST_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSRZA ADD CONSTRAINT RZA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.PLATN_DANEROZL ADD CONSTRAINT PLATDR_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATN_ADRES ADD CONSTRAINT PLATA_PK PRIMARY KEY (ID)
GO
 
ALTER TABLE dbo.ZUSZPA ADD CONSTRAINT ZPA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.UBEZP_ZUSRZA ADD CONSTRAINT URZA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.ZUSZWUA ADD CONSTRAINT ZWUA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.BLK_ZBA ADD CONSTRAINT BZBA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.IMPORT ADD CONSTRAINT IMP_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSRGA ADD CONSTRAINT RGA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.UBEZP_IDENT ADD CONSTRAINT UBEZPID_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.BLK_ZAA ADD CONSTRAINT BZAA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.CZR_ZUSZCNA ADD CONSTRAINT CZRZCNA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.PARAMETRY ADD CONSTRAINT PARAM_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZP_ZUSRGA ADD CONSTRAINT URGA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.PLATN_IDENT ADD CONSTRAINT PLATID_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATNIK ADD CONSTRAINT PLAT_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSZIUA ADD CONSTRAINT ZIUA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.HISTORIA ADD CONSTRAINT HIST_PK PRIMARY KEY (ID_UZYTKOWNIK, HASLO)
GO

ALTER TABLE dbo.CERTYFIKAT ADD CONSTRAINT CERT_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.BLAD_MIEDZY ADD CONSTRAINT BLM_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSZCNA ADD CONSTRAINT ZCNA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.PARAMETRY_PRZEKAZU ADD CONSTRAINT PAT_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZP_WYBOR ADD CONSTRAINT UBEZPWYB_PK PRIMARY KEY (ID_UBEZPIECZONY, ID_PROGRAM)
GO

ALTER TABLE dbo.ZUSZWPA ADD CONSTRAINT ZWPA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.ZUSRCA ADD CONSTRAINT RCA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.KODTYTUB ADD CONSTRAINT KODT_PK PRIMARY KEY (KODTYTUB)
GO

ALTER TABLE dbo.MIEJSCE ADD CONSTRAINT MIEJ_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZP_ZUSRCA ADD CONSTRAINT URCA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.UBEZP_ZUSRPA ADD CONSTRAINT URPA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.ZUSRSA ADD CONSTRAINT RSA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.CRL ADD CONSTRAINT CRL_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.CZR_ZUSZCZA ADD CONSTRAINT CZRZCZA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.DOKUMENT_PLATNICZY ADD CONSTRAINT DOKPL_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSZZA ADD CONSTRAINT ZZA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.UBEZP_ZUSRSA ADD CONSTRAINT URSA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.UZYTKOWNIK ADD CONSTRAINT UZYTK_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSZIPA ADD CONSTRAINT ZIPA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.ZUSZCZA ADD CONSTRAINT ZCZA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.UPRAWNIENIA ADD CONSTRAINT UPR_PK PRIMARY KEY (ID_UZYTKOWNIK, ID_PLATNIK)
GO

ALTER TABLE dbo.UBEZP_INNE ADD CONSTRAINT UBEZPINN_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZP_KOD_PRACY ADD CONSTRAINT UBEZPKPR_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATNIK_PARAMETR ADD CONSTRAINT PLATPAR_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.PLATN_RACHBANK ADD CONSTRAINT PLATRB_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSDRA ADD CONSTRAINT DRA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.ZUSZFA ADD CONSTRAINT ZFA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.WIADOMOSC ADD CONSTRAINT WIAD_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.DZIENNIK ADD CONSTRAINT DZ_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ARCH_DZIENNIK ADD CONSTRAINT DZARCH_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSRNA ADD CONSTRAINT RNA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.ZUSZUA ADD CONSTRAINT ZUA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.NIEJED ADD CONSTRAINT NIEJ_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.UBEZP_ZUSRNA ADD CONSTRAINT URNA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.PLATNIK ADD CONSTRAINT UK_PLATNIK_SYMBOL UNIQUE (NAZWASKR)
GO

ALTER TABLE dbo.ZUSZSWA ADD CONSTRAINT ZSWA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.UBEZP_ZUSZSWA ADD CONSTRAINT UZSWA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.LISTA_ODDZIAL ADD CONSTRAINT LISTA_ODDZIAL_PK PRIMARY KEY (ID)
GO

ALTER TABLE dbo.ZUSOSW ADD CONSTRAINT ZUSOSW_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.ZUSDRA2RCA2 ADD CONSTRAINT ZUSDRA2RCA2_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.ZUSRPA ADD CONSTRAINT ZUSRPA_PK PRIMARY KEY (ID_DOKUMENT)
GO

ALTER TABLE dbo.ZUSRIA ADD CONSTRAINT ZUSRIA_PK PRIMARY KEY (ID_DOKUMENT)
GO

CREATE INDEX IX_UID_UBEZPIECZONY ON dbo.DOKUMENT (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_URCA_UBEZPIECZONY ON dbo.UBEZP_ZUSRCA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_URPA_UBEZPIECZONY ON dbo.UBEZP_ZUSRPA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_URGA_UBEZPIECZONY ON dbo.UBEZP_ZUSRGA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_URNA_UBEZPIECZONY ON dbo.UBEZP_ZUSRNA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_URSA_UBEZPIECZONY ON dbo.UBEZP_ZUSRSA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_URZA_UBEZPIECZONY ON dbo.UBEZP_ZUSRZA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_RZA_IDOKRES2 ON dbo.ZUSRZA (I_1_1IDRAPS, I_1_2OKRROZL)
GO

CREATE INDEX IX_RCA_IDOKRES2 ON dbo.ZUSRCA (I_1_1IDRAPS, I_1_2OKRROZL)
GO

CREATE INDEX IX_RPA_IDOKRES2 ON dbo.ZUSRPA (I_1_1IDRAPS, I_1_2OKRROZL)
GO

CREATE INDEX IX_RSA_IDOKRES2 ON dbo.ZUSRSA (I_1_1IDRAPS, I_1_2OKRROZL)
GO

CREATE INDEX IX_RGA_IDOKRES2 ON dbo.ZUSRGA (I_1_1IDRAPS, I_1_2OKRROZL)
GO

CREATE INDEX IX_RNA_IDOKRES2 ON dbo.ZUSRNA (I_1_1IDRAPS, I_1_2OKRROZL)
GO

CREATE INDEX IX_DOK_PLATNIK ON dbo.DOKUMENT (ID_PLATNIK)
GO

CREATE INDEX IX_DOK_INSERTTMP ON dbo.DOKUMENT (INSERTTMP)
GO

CREATE INDEX IX_TMP_PROGRAM ON dbo.TMP_TAB (ID_PROGRAM)
GO

CREATE INDEX IX_TMP_DOK ON dbo.TMP_TAB (ID_1, ID_2)
GO

CREATE INDEX IX_BLOKADA_PROGRAM ON dbo.BLOKADA (ID_PROGRAM)
GO

CREATE  UNIQUE INDEX IX_BLOKADA ON dbo.BLOKADA 
  (ID_OBIEKT,
   ID_PLATNIK,
   ID_UBEZPIECZONY,
   POZIOM,
   TYP,
   ID_BLOKADA,
   KONTEKST)
GO

CREATE INDEX IX_RZA_IDOKRES ON dbo.ZUSRZA (I_1_2OKRROZL, I_1_1IDRAPS)
GO

CREATE INDEX IX_URZA_IDDOKNAD ON dbo.UBEZP_ZUSRZA (ID_DOK_NAD)
GO

CREATE INDEX IX_ZWUA_UBEZPIECZONY ON dbo.ZUSZWUA (ID_UBEZPIECZONY)
GO

CREATE INDEX IND_ZBA ON dbo.BLK_ZBA (ID_DOK_NAD)
GO

CREATE INDEX IX_RGA_IDOKRES ON dbo.ZUSRGA (I_1_2OKRROZL, I_1_1IDRAPS)
GO

CREATE INDEX IND_ZAA ON dbo.BLK_ZAA (ID_DOK_NAD)
GO

CREATE INDEX IX_CZRZCNA_IDDOKNAD ON dbo.CZR_ZUSZCNA (ID_DOK_NAD)
GO

CREATE INDEX IX_PARAM_NAZWA ON dbo.PARAMETRY (NAZWA)
GO

CREATE INDEX IX_PARAM_DATY ON dbo.PARAMETRY (DATAOD, DATADO)
GO

CREATE INDEX IX_URGA_IDDOKNAD ON dbo.UBEZP_ZUSRGA (ID_DOK_NAD)
GO

CREATE INDEX IX_PLATID_PLATNIK ON dbo.PLATN_IDENT (ID_PLATNIK)
GO

CREATE INDEX IX_ZIUA_UBEZPIECZONY ON dbo.ZUSZIUA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_ZCNA_UBEZPIECZONY ON dbo.ZUSZCNA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_RCA_IDOKRES ON dbo.ZUSRCA (I_1_2OKRROZL, I_1_1IDRAPS)
GO

CREATE INDEX IX_MIEJ_BLAD ON dbo.MIEJSCE (ID_BLAD)
GO

CREATE INDEX IX_URCA_IDDOKNAD ON dbo.UBEZP_ZUSRCA (ID_DOK_NAD)
GO

CREATE INDEX IX_RSA_IDOKRES ON dbo.ZUSRSA (I_1_2OKRROZL, I_1_1IDRAPS)
GO

CREATE INDEX IX_CZRZCZA_IDDOKNAD ON dbo.CZR_ZUSZCZA (ID_DOK_NAD)
GO

CREATE INDEX IX_ZZA_UBEZPIECZONY ON dbo.ZUSZZA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_URSA_IDDOKNAD ON dbo.UBEZP_ZUSRSA (ID_DOK_NAD)
GO

CREATE  UNIQUE INDEX IX_UZYTK_LOGIN ON dbo.UZYTKOWNIK (LOGIN)
GO

CREATE INDEX IX_ZCZA_UBEZPIECZONY ON dbo.ZUSZCZA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_DRA_IDOKRES ON dbo.ZUSDRA (I_2_2OKRESDEKLAR, I_2_1IDDEKLS)
GO

CREATE INDEX IX_ID_DOK ON dbo.ZESTAW_DOKUM (ID_DOKUMENT)
GO

CREATE INDEX IX_ZESTDOK_ZEST ON dbo.ZESTAW_DOKUM (ID_ZESTAW, STATUS)
GO

CREATE INDEX IX_ZESTDOK_NR_DOK ON dbo.ZESTAW_DOKUM (ID_ZESTAW, NR_DOKUMENT, ID_DOKUMENT)
GO

CREATE INDEX IX_DZ_CZAS ON dbo.DZIENNIK (CZAS)
GO

CREATE INDEX IX_DZ_UZYTKOWNIK ON dbo.DZIENNIK (ID_UZYTKOWNIK)
GO

CREATE INDEX IX_DZ_PLATNIK ON dbo.DZIENNIK (ID_PLATNIK)
GO

CREATE INDEX IX_DZARCH_PLATNIK ON dbo.ARCH_DZIENNIK (ID_PLATNIK)
GO

CREATE INDEX IX_DZARCH_CZAS ON dbo.ARCH_DZIENNIK (CZAS)
GO

CREATE INDEX IX_DZARCH_UZYTKOWNIK ON dbo.ARCH_DZIENNIK (ID_UZYTKOWNIK)
GO

CREATE INDEX IX_RNA_IDOKRES ON dbo.ZUSRNA (I_1_2OKRROZL, I_1_1IDRAPS)
GO

CREATE INDEX IX_ZUA_UBEZPIECZONY ON dbo.ZUSZUA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_URNA_IDDOKNAD ON dbo.UBEZP_ZUSRNA (ID_DOK_NAD)
GO

CREATE INDEX IX_TMPTAB_NR_IDPLATN ON dbo.TMP_TAB (NUMER, ID_PROGRAM)
GO

CREATE INDEX IX_UBEZP_WYBOR_PROGRAM ON dbo.UBEZP_WYBOR (ID_PROGRAM)
GO

CREATE INDEX IX_ID_SDWINAGLOWEK ON dbo.SDWI_UBEZPIECZONY (ID_SDWINAGLOWEK)
GO

CREATE INDEX IX_ID_SDWIUBEZPIECZONY ON dbo.SDWI_UBEZPIECZONY (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_BLAD_DOK_MAIN ON dbo.BLAD_DOK (ID_OBIEKT, TYP, ID_BLOK_BLW, KLASA)
GO

CREATE INDEX IX_BLAD_MIEDZY ON dbo.BLAD_MIEDZY (ID_PLATNIK, ID_ZESTAW, KLASA)
GO

CREATE INDEX IX_CERT_MAIN ON dbo.CERTYFIKAT (NUMER_SER, ID_PLATNIK , CERT_TYP)
GO

CREATE INDEX IX_DOK_IDDOKNAD ON dbo.DOKUMENT (ID_DOK_NAD,STATUSPT)
GO

CREATE INDEX IX_PP_ID_WARTOSC ON dbo.PLATNIK_PARAMETR (ID, WARTOSC)
GO

CREATE INDEX IX_TMP_TAB_SCAL ON dbo.TMP_TAB (ID_PROGRAM, ID_PLATNIK, ID_UBEZPIECZONY, ID_1, ID_2)
GO

CREATE CLUSTERED INDEX IX_DZNN_LST_ID ON dbo.LISTA_DZIENNIK (ID_ZDARZENIA, NAZWA)
GO

CREATE INDEX IX_DOK_PLATN_ID_PLATN ON dbo.DOKUMENT_PLATNICZY (ID_PLATNIK, ID_DOKUMENT)
GO

CREATE INDEX IX_UBEZP_ADRES_U ON dbo.UBEZP_ADRES (ID_UBEZPIECZONY, STATUS_DANE)
GO

CREATE INDEX IX_UBEZPID_UBEZP ON dbo.UBEZP_IDENT (ID_UBEZPIECZONY, STATUS_DANE)
GO

CREATE INDEX IX_UBEZPINN_UBEZP ON dbo.UBEZP_INNE (ID_UBEZPIECZONY, STATUS_DANE)
GO

CREATE INDEX IX_UBEZPKPR_UBEZP ON dbo.UBEZP_KOD_PRACY (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_ZEST_PLATNIK ON dbo.ZESTAW (ID_PLATNIK, STATUSPT, NUMER)
GO

CREATE INDEX IX_KOMUNIKAT_PLATNIK ON dbo.KOMUNIKAT (ID_PLATNIK)
GO

CREATE INDEX IX_KOMUNIKAT_BIURO ON dbo.KOMUNIKAT (ID_BIURO)
GO

CREATE UNIQUE INDEX IX_ZALACZNIK_KOM_LP ON dbo.ZALACZNIK (ID_KOMUNIKAT, LP)
GO

CREATE INDEX IX_UZSWA_UBEZPIECZONY ON dbo.UBEZP_ZUSZSWA (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_UZSWA_IDDOKNAD ON dbo.UBEZP_ZUSZSWA (ID_DOK_NAD)
GO

CREATE INDEX IX_USKLAD_IDDOKNR ON dbo.UBEZP_SKLAD (ID_DOKUMENT, NR_PODDOKUMENTU)
GO

CREATE INDEX IX_USWIAD_IDDOKNR ON dbo.UBEZP_SWIAD (ID_DOKUMENT, NR_PODDOKUMENTU)
GO

CREATE INDEX IX_BLAD_PRZETW ON dbo.BLAD_PRZETW (ID_DOKUMENT, NR_POZYCJI)
GO

CREATE INDEX IX_BLPRZETW_PRZES ON dbo.BLAD_PRZETW (ID_PRZESYLKI)
GO

CREATE INDEX IX_UBEZP_PODLEGANIE_UB ON dbo.UBEZP_PODLEGANIE (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_UBEZP_30KROTNOSC_UB ON dbo.UBEZP_30KROTNOSC (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_UBEZP_CZLONEK_RODZINY_UB ON dbo.UBEZP_CZLONEK_RODZINY (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_UBEZP_SKLAD_UB ON dbo.UBEZP_SKLAD (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_UBEZP_SWIAD_UB ON dbo.UBEZP_SWIAD (ID_UBEZPIECZONY)
GO

CREATE INDEX IX_NIEJED_IDDOK1 ON dbo.NIEJED (ID_DOK1)
GO

CREATE INDEX IX_NIEJED_IDDOK2 ON dbo.NIEJED (ID_DOK2)
GO

CREATE INDEX IX_NIEJED_TYP1 ON dbo.NIEJED (TYP1)
GO

CREATE INDEX IX_NIEJED_TYP2 ON dbo.NIEJED (TYP2)
GO

CREATE INDEX IX_UBEZPID_PESEL ON dbo.UBEZP_IDENT (PESEL)
GO

CREATE INDEX IX_UBEZPIECZONY_UZ ON dbo.UBEZPIECZONY (ID_UB_ZUS)
GO

CREATE INDEX IX_UBEZP_ADRES_UZ ON dbo.UBEZP_ADRES (ID_UB_ZUS)
GO

CREATE INDEX IX_UBEZPID_UZ ON dbo.UBEZP_IDENT (ID_UB_ZUS)
GO

CREATE INDEX IX_UBEZPINN_UZ ON dbo.UBEZP_INNE (ID_UB_ZUS)
GO

CREATE INDEX IX_UBEZPKPR_UZ ON dbo.UBEZP_KOD_PRACY (ID_UB_ZUS)
GO

CREATE INDEX IX_UBEZP_CZLONEK_RODZINY_UZ ON dbo.UBEZP_CZLONEK_RODZINY (ID_UB_ZUS)
GO

CREATE INDEX IX_UBEZP_30KROTNOSC_UZ ON dbo.UBEZP_30KROTNOSC (ID_UB_ZUS)
GO

CREATE INDEX IX_UBEZP_PODLEGANIE_UZ ON dbo.UBEZP_PODLEGANIE (ID_UB_ZUS)
GO

CREATE INDEX IX_UBEZP_SKLAD_UZ ON dbo.UBEZP_SKLAD (ID_UB_ZUS)
GO

CREATE INDEX IX_UBEZP_SWIAD_UZ ON dbo.UBEZP_SWIAD (ID_UB_ZUS)
GO

CREATE INDEX IX_DOK_NRBLOK ON dbo.DOKUMENT (ID_DOK_NAD,NR_BLOK)
GO

CREATE INDEX IX_URCA_NRBLOK ON dbo.UBEZP_ZUSRCA (ID_DOK_NAD,NR_BLOK)
GO

CREATE INDEX IX_URSA_NRBLOK ON dbo.UBEZP_ZUSRSA (ID_DOK_NAD,NR_BLOK)
GO

CREATE INDEX IX_URZA_NRBLOK ON dbo.UBEZP_ZUSRZA (ID_DOK_NAD,NR_BLOK)
GO

CREATE UNIQUE INDEX IX_NAZWAODDZIAL ON dbo.LISTA_ODDZIAL (NAZWAODDZIAL)
GO

INSERT INTO PARAM_KONF (NAZWA, WARTOSC1, WARTOSC2) VALUES('WersjaBazy', '1002003', NULL)
GO